% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_select_k_features.R
\name{fp_select_k_features}
\alias{fp_select_k_features}
\title{A feature preprocessor (FP) that reduces data to the k most selective features}
\usage{
fp_select_k_features(
  ndr_container_or_object = NULL,
  num_sites_to_use = NA,
  num_sites_to_exclude = NA
)
}
\arguments{
\item{ndr_container_or_object}{The purpose of this argument is to make the
constructor of the fp_select_k_features feature preprocessor work with the
pipe (|>) operator. This argument should almost never be directly
set by the user to anything other than NULL. If this is set to the default
value of NULL, then the constructor will return a fp_select_k_features
object. If this is set to an ndr container, then a fp_select_k_features
object will be added to the container and the container will be returned.
If this argument is set to another ndr object, then both that ndr object as
well as a new fp_select_k_features object will be added to a new container
and the container will be returned.}

\item{num_sites_to_use}{The number of features with the smallest p-values to use.}

\item{num_sites_to_exclude}{The number of features with the smallest p-values
that should be excluded.}
}
\value{
This constructor creates an NDR feature preprocessor object with the
class \code{fp_select_k_features}. Like all NDR feature preprocessor objects,
this feature preprocessor will be used by the cross-validator to
pre-process the training and test data sets.
}
\description{
This feature preprocessor object applies an ANOVA to the training data to
find the p-value of all features. It then either uses the top k features with
the smallest p-values, or it removes the features with the smallest k
p-values. Additionally, this function can be used to remove the top k
p-values and then use only the following j next smallest p-values (for
example, this can be useful if one is interesting in comparing the
performance using the most selective 10 neurons to using the next 10 most
selective neurons, etc.).
}
\examples{
# This will cause the cross-validator use only the 50 most selective sites
fp <- fp_select_k_features(num_sites_to_use = 50)

# This will cause the cross-validator to remove the 20 most selective sites
fp <- fp_select_k_features(num_sites_to_exclude = 20)

# This will cause the cross-validator to remove the 20 most selective sites
# and then use only the 50 most selective sites that remain after the 20 are
# eliminated
fp <- fp_select_k_features(num_sites_to_use = 50, num_sites_to_exclude = 20)
}
\seealso{
Other feature_preprocessor: 
\code{\link{fp_zscore}()}
}
\concept{feature_preprocessor}
