% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{estimate}
\alias{estimate}
\title{estimate}
\usage{
estimate(estimator, Z, X = NULL, batchsize = 32, use_gpu = TRUE)
}
\arguments{
\item{estimator}{a neural estimator that can be applied to data in a call of the form \code{estimator(Z)}}

\item{Z}{data in a format amenable to the neural-network architecture of \code{estimator}}

\item{X}{additional inputs to the neural network; if provided, the call will be of the form \verb{estimator((Z, X))}}

\item{batchsize}{the batch size for applying \code{estimator} to \code{Z}. Batching occurs only if \code{Z} is a list, indicating multiple data sets}

\item{use_gpu}{boolean indicating whether to use the GPU if it is available}
}
\value{
a matrix of outputs resulting from applying \code{estimator} to \code{Z} (and possibly \code{X})
}
\description{
Apply a neural estimator to data
}
\seealso{
\code{\link[=sampleposterior]{sampleposterior()}} for making inference with neural posterior or likelihood-to-evidence-ratio estimators
}
