% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{sf2turtles}
\alias{sf2turtles}
\alias{sf2turtles,ANY-method}
\title{From \code{sf} to \code{agentMatrix}}
\usage{
sf2turtles(turtles_sf)

\S4method{sf2turtles}{ANY}(turtles_sf)
}
\arguments{
\item{turtles_sf}{\code{sf} object of \verb{POINT geometry} representing moving \code{agents}.}
}
\value{
\code{AgentMatrix} object representing the moving \code{agents} (coordinates and data)
as contained in \code{turtles_sf}.
}
\description{
Convert a \code{sf} object into an \code{agentMatrix} object.
}
\details{
If the \code{turtles_sf} does not contain the variables created with
\code{createTurtles()}, these variables will be created with the
default values as in \code{createTurtles()}.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  turtles_sf1 <- sf::st_as_sf(
    cbind.data.frame(
      x = c(1, 2, 3), y = c(1, 2, 3),
      age = c(0, 0, 3), sex = c("F", "F", "M")
    ),
    coords = c("x", "y")
  )
  t1 <- sf2turtles(turtles_sf = turtles_sf1)
}

}
\author{
Sarah Bauduin
}
