% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{two_dist_match}
\alias{two_dist_match}
\title{Optimal tradeoffs among two distances and exclusion}
\usage{
two_dist_match(
  dist1_type = "user",
  dist2_type = "user",
  dist1_matrix = NULL,
  data = NULL,
  dist2_matrix = NULL,
  treat_col = NULL,
  dist1_col = NULL,
  dist2_col = NULL,
  exclusion_penalty = c(),
  dist2_penalty = c(),
  marg_bal_col = NULL,
  exact_col = NULL,
  propensity_col = NULL,
  pscore_name = NULL,
  ignore_col = NULL,
  max_unmatched = 0.25,
  caliper_option = NULL,
  tol = 0.01,
  max_iter = 1,
  rho_max_factor = 10,
  max_pareto_search_iter = 5
)
}
\arguments{
\item{dist1_type}{One of ("euclidean", "robust_mahalanobis", "user") indicating the
type of distance that are used for the first distance objective functions.
NULL by default.}

\item{dist2_type}{One of ("euclidean", "robust_mahalanobis", "user")  charactor
indicating the type of distance that are used for the second distance
objective functions. NULL by default.}

\item{dist1_matrix}{(optional) matrix object that represents the distance
matrix using the first distance measure; \code{dist1_type}
must be passed in as "user" if dist1_matrix is non-empty}

\item{data}{(optional) data frame that contain columns indicating treatment,
outcome and covariates}

\item{dist2_matrix}{(optional) matrix object that represents the distance
matrix using the second distance measure; \code{dist2_type} must be passed
in as "user" if dist2_matrix is non-empty}

\item{treat_col}{(optional) character, name of the column indicating
treatment assignment.}

\item{dist1_col}{(optional) character vector names of the variables used for
calculating covariate distance using first distance measure specified by
dType}

\item{dist2_col}{(optional) character vector, names of the variables used for
calculating covariate distance using second distance measure specified by
dType1}

\item{exclusion_penalty}{(optional) numeric vector, penalty values associated
with exclusion. Empty by default, where auto grid search is triggered.}

\item{dist2_penalty}{(optional) numeric vector, penalty values associated
with the distance specified by \code{dist2_matrix} or \code{dist2_type}.
Empty by default, where auto grid search is tiggered.}

\item{marg_bal_col}{(optional) character, column name of the variable on
which to evaluate balance.}

\item{exact_col}{(optional) character vector, names of the variables on which
to match exactly; NULL by default.}

\item{propensity_col}{character vector, names of columns on which to fit a
propensity score model.}

\item{pscore_name}{(optional) character, name of the column containing fitted
propensity scores; default is NULL.}

\item{ignore_col}{(optional) character vector of variable names that should
be ignored when constructing the internal matching. NULL by default.}

\item{max_unmatched}{(optional) numeric, maximum proportion of unmatched
units that can be accepted; default is 0.25.}

\item{caliper_option}{(optional) numeric, the propensity score caliper value
in standard deviations of the estimated propensity scores; default is NULL,
which is no caliper.}

\item{tol}{(optional) numeric, tolerance of close match distance;
default is 1e-2.}

\item{max_iter}{(optional) integer,  maximum number of iterations to use in
searching for penalty combintions that improve the matching; default is 1,
where the algorithm searches for one round.}

\item{rho_max_factor}{(optional) numeric, the scaling factor used in proposal
for penalties; default is 10.}

\item{max_pareto_search_iter}{(optional) numeric, the number of tries to
search for the tol that yield pareto optimal solutions; default is 5.}
}
\value{
a named list whose elements are:
\itemize{
\item "rhoList": list of penalty
combinations for each match
\item "matchList": list of matches indexed by
number
\item "treatmentCol": character of treatment variable
\item "covs":character vector of names of the variables used for calculating within-pair
distance
\item "exactCovs": character vector of names of variables that we want
exact or close match on
\item "idMapping": numeric vector of row indices for
each observation in the sorted data frame for internal use
\item "stats": data
frame of important statistics (total variation distance) for variable on
which marginal balance is measured
\item "b.var": character, name of variable
on which marginal balance is measured (left NULL since no balance
constraint is imposed here).
\item "dataTable": data frame sorted by treatment
value
\item "t": a treatment vector
\item "df": the original dataframe input by the
user
\item "pair_cost1": list of pair-wise distance sum using the first
distance measure
\item "pair_cost2": list of pair-wise distance sum using the
second distance measure
\item "version": (for internal use) the version of the
matching function called; "Basic" indicates the matching comes from
dist_bal_match and "Advanced" from two_dist_match.
\item "fDist1": a vector of
values for the first objective function; it corresponds to the pair-wise
distance sum according to the first distance measure.
\item "fExclude": a
vector of values for the second objective function; it corresponds to the
number of treated units being unmatched.
\item "fDist2": a vector of values for
the third objective function; it corresponds to the pair-wise distance sum
corresponds to the
}
}
\description{
Explores tradeoffs among three objective functions in
multivariate matching: sums of two different user-specified  covariate
distances within matched pairs, and the number of treated units included in
the match.
}
\details{
Matched designs generated by this function are Pareto optimal for
the three objective functions.  The degree of relative emphasis among the
three objectives in any specific solution is controlled by the penalties,
denoted by Greek letter rho. Larger values for the penalties associated with
the two distances correspond to increased emphasis close matching on these
distances, at the possible cost of excluding more treated units. Additional
details:
\itemize{
\item Users may either specify their own distance matrices (specifying
the \code{User} option in \code{dist1_type} and/or \code{dist2_type} and
supplying arguments to
\code{dist1_matrix} and/or \code{dist2_matrix} respectively) or ask the function
to create Mahalanobis or Euclidean distances on sets of covariates specified
by the \code{dist1_col} and \code{dist2_col} arguments. If \code{dist1_type} or \code{dist2_type}
is not specified, if one of these is set to \code{user} and the corresponding
\code{dist1_matrix} argument is not provided, or if one is NOT set to \code{User}
and the corresponding \code{dist1_col} argument is not provided, the code would
error out.
\item User-specified distance matrices passed to \code{dist1_matrix} or \code{dist2_matrix}
should have row count equal to the number of treated units and column count
equal to the number of controls.
\item If the \code{caliper_option} argument is specified, a
propensity score caliper will be imposed, forbidding matches between units
more than a fixed distance apart on the propensity score.  The caliper will
be based either on a user-fit propensity score, identified in the input
dataframe by argument \code{pscore_name}, or by an internally-fit propensity score
based on logistic regression against the variables named in \code{propensity_col}.
If \code{caliper_option} is non-NULL and neither of the other arguments is
specified an error will result.
\item \code{tol} controls the precision at which the
objective functions is evaluated. When matching problems are especially large
or complex it may be necessary to increase toleranceOption in order to
prevent integer overflows in the underlying network flow solver; generally
this will be suggested in appropariate warning messages.
\item While by default
tradeoffs are only assessed at penalty combinations provided by the user, the
user may ask for the algorithm to search over additional penalty values in
order to identify additional Pareto optimal solutions. \code{rho_max_factor} is a
multiplier applied to initial penalty values to discover new solutions, and
setting it larger leads to wider exploration; similarly, \code{max_iter} controls
how long the exploration routine runs, with larger values leading to more
exploration.
}
}
\examples{
x1 = rnorm(100, 0, 0.5)
x2 = rnorm(100, 0, 0.1)
x3 = rnorm(100, 0, 1)
x4 = rnorm(100, x1, 0.1)
r1ss <- seq(0.1,50, 10)
r2ss <- seq(0.1,50, 10)
x = cbind(x1, x2, x3,x4)
z = sample(c(rep(1, 50), rep(0, 50)))
e1 = rnorm(100, 0, 1.5)
e0 = rnorm(100, 0, 1.5)
y1impute = x1^2 + 0.6*x2^2 + 1 + e1
y0impute = x1^2 + 0.6*x2^2 + e0
treat = (z==1)
y = ifelse(treat, y1impute, y0impute)
names(x) <- c("x1", "x2", "x3", "x4")
df <- data.frame(cbind(z, y, x))
df$x5 <- 1
names(x) <- c("x1", "x2", "x3", "x4")
df <- data.frame(cbind(z, y, x))
df$x5 <- 1
d1 <- as.matrix(dist(df["x1"]))
d2 <- as.matrix(dist(df["x2"]))
idx <- 1:length(z)
treated_units <- idx[z==1]
control_units <- idx[z==0]
d1 <- as.matrix(d1[treated_units, control_units])
d2 <- as.matrix(d2[treated_units, control_units])
match_result_1 <- two_dist_match(data=df, treat_col="z",  dist1_matrix=d1, 
dist1_type= "User", dist2_matrix=d2,
dist2_type="User", marg_bal_col=c("x5"), exclusion_penalty=r1ss, 
dist2_penalty=r2ss,
propensity_col = c("x1"), max_iter = 0,
max_pareto_search_iter = 0) 
}
\seealso{
Other main matching function: 
\code{\link{dist_bal_match}()}
}
\concept{main matching function}
