% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{matched_data}
\alias{matched_data}
\title{Get matched dataframe}
\usage{
matched_data(matching_result, match_num)
}
\arguments{
\item{matching_result}{an object returned by the main matching function
dist_bal_match}

\item{match_num}{Integer index of match that the user want to extract paired
observations from}
}
\value{
dataframe that contains only matched pair data
}
\description{
A function that returns the dataframe that contains only matched
pairs from the original data frame with specified match index
}
\examples{
## Generate Matches
data("lalonde", package="cobalt")
ps_cols <- c("age", "educ", "married", "nodegree", "race")
treat_val <- "treat"
response_val <- "re78"  
pair_dist_val <- c("age", "married", "educ", "nodegree", "race")
my_bal_val <- c("race")
r1s <- c(0.01,1,2,4,4.4,5.2,5.4,5.6,5.8,6)
r2s <- c(0.001)
match_result <- dist_bal_match(data=lalonde, treat_col= treat_val, 
marg_bal_col = my_bal_val, exclusion_penalty=r1s, balance_penalty=r2s, 
dist_col = pair_dist_val, 
propensity_col = ps_cols, max_iter=0)
matched_data(match_result, 1)
}
