% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmv-class.R
\docType{class}
\name{cvmv-class}
\alias{cvmv-class}
\alias{cvmv}
\alias{show,cvmv-method}
\alias{summary,cvmv-method}
\alias{plot,cvmv,ANY-method}
\alias{cvmv-method}
\title{The cvmv Class.}
\usage{
\S4method{show}{cvmv}(object)

\S4method{summary}{cvmv}(object)

\S4method{plot}{cvmv,ANY}(x, y, ...)
}
\arguments{
\item{object}{A cvmv class object}

\item{x}{A cvmv class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{CVMajorityvotes}}.
}
\section{Slots}{

\describe{
\item{\code{HRTrain}}{A matrix of survival information for the training dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}

\item{\code{HRTest}}{A matrix of survival information for the test dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}

\item{\code{Ncv}}{The number of cross validation used.}

\item{\code{Micro.mat}}{The microbiome data matrix that was used for the analysis either same as Micro.mat or a reduced version.}

\item{\code{Progfact}}{The names of prognostic factors used.}
}}

\seealso{
\code{\link[MicrobiomeSurv]{Majorityvotes}}, \code{\link[MicrobiomeSurv]{CVPcaPls}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
