% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetabolicSurvClass.R
\docType{class}
\name{cvpp-class}
\alias{cvpp-class}
\title{The cvpp Class.}
\description{
The cvpp Class.
}
\section{Slots}{

\describe{
\item{\code{Results}}{A dataframe containg the estimated Hazard ratio of the test
dataset and the training dataset}

\item{\code{Ncv}}{The number of cross validation performed}

\item{\code{Method}}{The dimesion reduction method used}

\item{\code{CVtrain}}{The training dataset indices matrix used for the cross
validation}

\item{\code{CVtest}}{The test dataset indices matrix used for the cross validation}

\item{\code{Nmet}}{The number of metabolite used for the dimesion reduction method
used}
}}

\examples{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## USING THE FUNCTION
Result = CVPcaPls(Fold = 4, Survival = Data$Survival,
Mdata = t(Data$Mdata), Censor = Data$Censor, Reduce=TRUE,
Select=19, Prognostic= Data$Prognostic,Ncv=55,DR ="PLS")

## GET THE CLASS OF THE OBJECT
class(Result)     # A "cvpp" Class

##  METHOD THAT CAN BE USED FOR THE RESULT
show(Result)
summary(Result)
plot(Result)
}
\seealso{
\code{\link[MetabolicSurv]{CVPcaPls}}, \code{\link[MetabolicSurv]{SurvPcaClass}}, \code{\link[MetabolicSurv]{SurvPlsClass}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
