% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.net_compare.R
\name{c_net_compare}
\alias{c_net_compare}
\title{Compare Two Networks}
\usage{
c_net_compare(g1, g2)
}
\arguments{
\item{g1}{network1}

\item{g2}{network2}
}
\value{
A list containing the following elements:
\itemize{
\item \code{g1}: The first network.
\item \code{g2}: The second network.
\item \code{g_union}: The union of the two networks.
\item \code{g_inter}: The intersection of the two networks.
\item \code{net_par_df}: A data frame containing the network parameters.
\item \code{net_similarity}: A list containing the similarity metrics.
}
}
\description{
Compare Two Networks
}
\examples{
data("c_net")
set.seed(12)
co_net_p1 <- c_net_filter(co_net, name \%in\% sample(V(co_net)$name, 300))
co_net_p2 <- c_net_filter(co_net, name \%in\% sample(V(co_net)$name, 300))
c_net_compare(co_net_p1, co_net_p2) -> c_net_comp
plot(c_net_comp)
}
