% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugs.R
\name{summary.PUGS}
\alias{summary.PUGS}
\title{Gather samples of predictions}
\usage{
\method{summary}{PUGS}(object, ...)
}
\arguments{
\item{object}{A \code{pugs} object generated by \code{\link{predict.ECC}}.}

\item{...}{\code{type = "prob"} for probabilistic predictions,
\code{type = "class"} for binary (0/1) predictions}
}
\value{
A matrix of predictions.
}
\description{
Collapses the multi-label predictions across sets of classifier
  chains and iterations into a single set of predictions, either binary or
  probabilistic.
}
\examples{
x <- movies_train[, -(1:3)]
y <- movies_train[, 1:3]

model_glm <- ecc(x, y, m = 1, .f = glm.fit, family = binomial(link = "logit"))

predictions_glm <- predict(model_glm, movies_test[, -(1:3)],
.f = function(glm_fit, newdata) {

  # Credit for writing the prediction function that works
  # with objects created through glm.fit goes to Thomas Lumley
  
  eta <- as.matrix(newdata) \%*\% glm_fit$coef
  output <- glm_fit$family$linkinv(eta)
  colnames(output) <- "1"
  return(output)
  
}, n.iters = 10, burn.in = 0, thin = 1)

summary(predictions_glm, movies_test[, 1:3])

\dontrun{

model_c50 <- ecc(x, y, .f = C50::C5.0)
predictions_c50 <- predict(model_c50, movies_test[, -(1:3)],
                           n.iters = 10, burn.in = 0, thin = 1,
                           .f = C50::predict.C5.0, type = "prob")
summary(predictions_c50, movies_test[, 1:3])
  
model_rf <- ecc(x, y, .f = randomForest::randomForest)
predictions_rf <- predict(model_rf, movies_test[, -(1:3)],
                          n.iters = 10, burn.in = 0, thin = 1,
                          .f = function(rF, newdata){
                            randomForest:::predict.randomForest(rF, newdata, type = "prob")
                          })
summary(predictions_rf, movies_test[, 1:3])
}
}

