% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIDASim.modify.R
\name{MIDASim.modify}
\alias{MIDASim.modify}
\title{Modifying MIDASim model}
\usage{
MIDASim.modify(
  fitted,
  lib.size = NULL,
  mean.rel.abund = NULL,
  gengamma.mu = NULL,
  sample.1.prop = NULL,
  taxa.1.prop = NULL,
  individual.rel.abund = NULL,
  ...
)
}
\arguments{
\item{fitted}{Output from MIDASim.setup.}

\item{lib.size}{Numeric vector of pre-specified library sizes (length should
be equal to \code{n.sample} if specified). In nonparametric mode, if \code{lib.size}
is specified, both \code{taxa.1.prop} and \code{sample.1.prop} should be specified.}

\item{mean.rel.abund}{Numeric vector of specified mean relative abundances for
taxa. Length should be equal to \code{n.taxa} in \code{fitted}.}

\item{gengamma.mu}{Numeric vector of specified location parameters for the
parametric model (generalized gamma model). Specify either \code{mean.rel.abund}
or \code{gengamma.mu}, not both. Length should be equal to \code{n.taxa} in \code{fitted}.
See Details. This argument is only applicable in parametric mode.}

\item{sample.1.prop}{Numeric vector of specified proportion of non-zeros for
subjects (the length should be equal to \code{n.sample} in \code{fitted}). This
argument is only applicable in nonparametric mode.}

\item{taxa.1.prop}{Numeric vector of specified proportion of non-zeros for
taxa (the length should be equal to \code{n.taxa} in \code{fitted}). This argument
is only applicable in nonparametric mode.}

\item{individual.rel.abund}{Numeric matrix of expected relative abundances
with \code{n.sample} rows and \code{n.taxa} columns (rows should sum to 1).
Provides subject‑specific mean compositions and therefore overrides
\code{mean.rel.abund} and \code{gengamma.mu}. Only applicable in parametric mode.}

\item{...}{Additional arguments. If SCAM model is chosen for parameter changes
under the non-parametric mode, specify \code{SCAM = T}.}
}
\value{
Returns an updated list with different elements depending on the value
of \code{fitted$mode}:
\item{n.sample}{Target sample size in the simulation.}
\item{lib.size}{Target library sizes in the simulation.}
\item{taxa.1.prop}{Updated proportions of non-zero values for each taxon.}
\item{sample.1.prop}{Updated proportion of non-zero cells for each subject.}
\item{theta}{Mean values of the multivariate normal distribution in generating
presence-absence data.}
\item{eta}{Adjustment to be applied to samples in generating presence-
absence data.}
}
\description{
MIDASim.modify() modifies the fitted MIDASim.setup model according to user
specification that one or multiple of the following characteristics, such as
the library sizes, taxa relative abundances, location parameters of the parametric
model can be changed. This is useful if the users wants to introduce an 'effect'
in simulation studies.
}
\details{
The parametric model in MIDASim is a location-scale model, specifically, a
generalized gamma model for relative abundances \eqn{\pi} of a taxon. Denote \eqn{t = 1/\pi}.
The generalized gamma distribution for \eqn{t} is chosen so that

\deqn{ln(t)\ =\ \mu\ +\ \sigma \cdot w}

where \eqn{w} follows a log gamma distribution with a shape parameter \eqn{1/Q}.
MIDASim fits the model to the template data and estimates parameters \eqn{\mu}, \eqn{\sigma}
and \eqn{Q} by matching the first two moments of \eqn{\pi} and maximizing the likelihood.
}
\examples{
\donttest{
  data("throat.otu.tab")
  otu.tab = throat.otu.tab[,colSums(throat.otu.tab>0)>1]

  fitted = MIDASim.setup(otu.tab, mode = 'parametric')

  # modify library sizes
  fitted.modified <- MIDASim.modify(fitted,
                                    lib.size = sample(fitted$lib.size, 2*nrow(otu.tab),
                                                    replace = TRUE) )

  # modify mean relative abundances
  fitted.modified <- MIDASim.modify(fitted,
                                    mean.rel.abund = fitted$mean.rel.abund * runif(fitted$n.taxa))

}
}
\author{
Mengyu He
}
