% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cv_number.R
\name{add_cv_number}
\alias{add_cv_number}
\title{Assign a k-fold cross-validation number}
\usage{
add_cv_number(data_long, individual_id, k, seed = 1)
}
\arguments{
\item{data_long}{Data frame in long format i.e. there may be more than one row per individual}

\item{individual_id}{Character string specifying the column name in \code{data_long} which contains the individual identifiers}

\item{k}{Integer specifying the number of folds for cross-validation.
An alternative to setting parameter \code{cross_validation_df} for performing cross-validation; if both are missing no cross-validation is used.}

\item{seed}{The value of the seed (default is 1)}
}
\value{
Data frame \code{data_long} updated to contain a new column \code{cross_validation_number}
indicating the fold to which the individual has been assigned.
}
\description{
Randomly assigns a k-fold cross-validation number to each individual in a dataset.
}
\details{
This function randomly divides the \code{n} individual IDs
into \code{k} groups, each with \code{n/k} members (or as close to this number as possible).
}
\examples{
data(data_repeat_outcomes)
data_repeat_outcomes <- add_cv_number(data_long = data_repeat_outcomes,
                                      individual_id = "id",
                                      k = 10)
}
\author{
Isobel Barrott \email{isobel.barrott@gmail.com}
}
