% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverTShort.r
\name{Coverageshortmemory}
\alias{Coverageshortmemory}
\title{Calculate the coverage for several short-memory models}
\usage{
Coverageshortmemory(
  n,
  R,
  N,
  S,
  mu,
  dist,
  method,
  alpha,
  beta,
  start,
  Subdivisions = 100,
  m = 500,
  NN = 100,
  B,
  case,
  sign = 0.05
)
}
\arguments{
\item{n}{(type: numeric) size of the simulated series.}

\item{R}{(type: numeric) number of realizations of the Monte Carlo experiments.}

\item{N}{(type: numeric) sample size of each block.}

\item{S}{(type: numeric) shifting places from block to block. Observe that the number of blocks M is determined by the following formula \eqn{M = \left\lfloor \frac{T-N}{S} + 1 \right\rfloor}, where \eqn{\left\lfloor . \right\rfloor} takes a single numeric argument \code{x} and returns a numeric vector containing the integers formed by truncating the values in \code{x} toward \code{0}.}

\item{mu}{(type: numeric) trend coefficient of the regression model.}

\item{dist}{(type: character) white noise distribution for calculating coverage, it includes the \code{"normal"}, \code{"exponential"} and \code{"uniform"} univariate distributions.}

\item{method}{(type: character) methods are asymptotic (\code{"asym"}), bootstrap percentile (\code{"boot"}), bootstrap-t (\code{"boott"}) and bootstrap-SP (\code{"bootSP"}).}

\item{alpha}{(type: numeric) numeric vector with values to simulate the time varying autoregressive parameters of model LSAR(1), \eqn{\phi(u)}.}

\item{beta}{(type: numeric) numeric vector with values to simulate the time varying scale factor parameters of model LSAR(1), \eqn{\sigma(u)}.}

\item{start}{(type: numeric) numeric vector, initial values for parameters to run the model.}

\item{Subdivisions}{(type: numeric) the number of subintervals produced in the subdivision (integration) process; only required in the asymptotic method.}

\item{m}{(type: numeric) parameter that allows to remove the first m observations when simulating the LSAR process.}

\item{NN}{(type: numeric) parameter that allows to remove the first NN observations of noise from the LSAR model.}

\item{B}{(type: numeric) the number of bootstrap replicates, NULL indicates the asymptotic method.}

\item{case}{(type: character) nonlinear (\code{"no-linear"}) and linear cases (\code{"linear"}).}

\item{sign}{nominal significance level}
}
\value{
A data frame containing the following columns:
\itemize{
\item \code{n}: Size of each simulated series.
\item \code{method}: Statistical method used for simulation.
\item \code{coverage}: Proportion of true parameter values within the intervals.
\item \code{avg_width}: Average width of the intervals.
\item \code{sd_width}: Standard deviation of the interval widths.
}
}
\description{
Generates coverage metrics for a parameter of interest using a specified short-memory model.
}
\details{
This function estimates the parameters in the linear regression model for \eqn{t = 1, ..., T},
\deqn{Y_{t,T} = X_{t,T} \beta + \epsilon_{t,T},}
where a locally stationary autoregressive process of order one (LSAR(1)) is described by the equation:
\deqn{\epsilon_{t,T} = \phi(u) \epsilon_{t-1,T} + \sigma(u) \eta_t}
where u=t/T in [0,1], with
\eqn{\phi(u)} is the autoregressive coefficient which is modeled as a linear polynomial,
\eqn{\sigma(u)} is modeled as a quadratic polynomial, and {\eqn{\eta_t}} is a white noise sequence
with zero mean and unit variance.
This setup is referred to as a locally stationary autoregressive model (LSAR(1)).

Resampling methods evaluated:
\itemize{
\item asym: Asymptotic method that uses the asymptotic variance of the estimator, based
on the Central Limit Theorem, to construct confidence intervals under the
assumption of normality in large samples.
\item boot: Standard bootstrap that generates replicas of the estimator \eqn{\hat{\beta}} by resampling
the adjusted residuals \eqn{\hat{\epsilon}_t}. It approximates the distribution of the estimator by
the variability observed in the bootstrap replicas of \eqn{\hat{\beta}}.
\item boott: Adjusted bootstrap that scales the bootstrap replicas of the estimator
\eqn{\hat{\beta}} by its standard error, aiming to refine the precision of the confidence interval
and adjust for the variability in the parameter estimation.
\item bootSP: Symmetrized Percentile-t method, a variation of the boot-t that symmetrizes the
bootstrap distribution around zero to handle skewed distributions or outliers more effectively.
This method enhances the accuracy of confidence intervals by adjusting for asymmetries in the
bootstrap replicas.
}

For more details, see references.
}
\examples{
Coverageshortmemory(n=100,R=10,N=60,S=40,mu=0.5,dist="normal",method="asym",alpha=c(0.25,0.2),
beta=c(1,1,-0.5),start=c(0.15,0.15,1,1,-0.5),case="no-linear")

}
\references{
Ferreira G., Mateu J., Vilar J.A., Muñoz J. (2020). Bootstrapping regression models with locally stationary disturbances. TEST, 30, 341-363.
}
