% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{India_SharkTank_tbl_df}
\alias{India_SharkTank_tbl_df}
\title{Shark Tank India Dataset}
\format{
A tibble with 117 observations and 28 variables:
\describe{
  \item{episode_number}{Episode number (numeric)}
  \item{pitch_number}{Pitch number within the episode (numeric)}
  \item{brand_name}{Name of the brand presented (character)}
  \item{idea}{Business idea description (character)}
  \item{deal}{Indicator if a deal was made (numeric; 1 = yes, 0 = no)}
  \item{pitcher_ask_amount}{Amount requested by the pitcher (numeric)}
  \item{ask_equity}{Equity percentage requested by the pitcher (numeric)}
  \item{ask_valuation}{Valuation based on the pitcher’s ask (numeric)}
  \item{deal_amount}{Amount invested in the deal (numeric)}
  \item{deal_equity}{Equity percentage given in the deal (numeric)}
  \item{deal_valuation}{Valuation based on the deal (numeric)}
  \item{ashneer_present}{Indicator if Ashneer was present (numeric; 1 = yes, 0 = no)}
  \item{anupam_present}{Indicator if Anupam was present (numeric; 1 = yes, 0 = no)}
  \item{aman_present}{Indicator if Aman was present (numeric; 1 = yes, 0 = no)}
  \item{namita_present}{Indicator if Namita was present (numeric; 1 = yes, 0 = no)}
  \item{vineeta_present}{Indicator if Vineeta was present (numeric; 1 = yes, 0 = no)}
  \item{peyush_present}{Indicator if Peyush was present (numeric; 1 = yes, 0 = no)}
  \item{ghazal_present}{Indicator if Ghazal was present (numeric; 1 = yes, 0 = no)}
  \item{ashneer_deal}{Indicator if Ashneer invested (numeric; 1 = yes, 0 = no)}
  \item{anupam_deal}{Indicator if Anupam invested (numeric; 1 = yes, 0 = no)}
  \item{aman_deal}{Indicator if Aman invested (numeric; 1 = yes, 0 = no)}
  \item{namita_deal}{Indicator if Namita invested (numeric; 1 = yes, 0 = no)}
  \item{vineeta_deal}{Indicator if Vineeta invested (numeric; 1 = yes, 0 = no)}
  \item{peyush_deal}{Indicator if Peyush invested (numeric; 1 = yes, 0 = no)}
  \item{ghazal_deal}{Indicator if Ghazal invested (numeric; 1 = yes, 0 = no)}
  \item{total_sharks_invested}{Total number of sharks who invested (numeric)}
  \item{amount_per_shark}{Investment amount per shark (numeric)}
  \item{equity_per_shark}{Equity percentage per shark (numeric)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/shivavashishtha/shark-tank-india-dataset}
}
\usage{
data(India_SharkTank_tbl_df)
}
\description{
This dataset, India_SharkTank_tbl_df, is a tibble containing detailed information on pitches
presented on Shark Tank India. It includes episode and pitch numbers, brand names, business ideas,
deal status, financial details (ask amount, equity, valuation, deal amount, equity, and valuation),
presence of each shark during the pitch, whether each shark invested, total sharks invested,
amount per shark, and equity per shark. The dataset preserves the original structure from its source
on Kaggle.
}
\details{
The dataset name has been kept as 'India_SharkTank_tbl_df' to maintain consistency with the naming
conventions in the IndiAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame.
The original content has not been modified in any way.
}
