% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlayDensities.R
\name{iscamaddlnorm}
\alias{iscamaddlnorm}
\title{Overlay a Log Normal Density Function on Histogram}
\usage{
iscamaddlnorm(
  x,
  main = "Histogram with log-normal curve",
  xlab = deparse(substitute(x)),
  bins = NULL
)
}
\arguments{
\item{x}{A numeric vector representing the data to be plotted.}

\item{main}{(optional) title for the plot.}

\item{xlab}{(optional) x-axis label for the plot.}

\item{bins}{(optional) number of bins for the histogram.}
}
\value{
A histogram of x overlayed with an log normal density function.
}
\description{
\code{addlnorm} creates a histogram of \code{x} and overlays a log normal density function.
}
\examples{
set.seed(0)
x <- rlnorm(100)
iscamaddlnorm(x)
iscamaddlnorm(x, main = "Your Active Title", xlab = "Log Normal Data", bins = 20)
}
