\name{generateTree}
\alias{generateTree}
\title{Generate Test Trees}
\description{This function will take several initial trees and will randomly populate new trees based on the originals.}

\usage{generateTree(data, numReadsPerSamp, theta = NULL, level = "genus", split = ".")}

\arguments{
  \item{data}{A data frame in which each column contains the rdp read counts for every taxa given in the row names.}
  \item{numReadsPerSamp}{A vector specifying the number of reads or sequence depth for each sample.}
  \item{theta}{When theta is not NULL the base tree is generated by using the \code{dirmult} function.}
  \item{level}{The depth the tree will go down to (kingdom, phylum, class, order, family, genus, species, subspecies).}
  \item{split}{This is the character that separates the taxa levels in the row names.}
}

\value{A data frame containing the generated tree(s).}

\author{Patricio S. La Rosa, Elena Deych, Berkley Shands, William D. Shannon}

\examples{
	data(saliva)
	
	### Generate a the number of reads per sample
	### The first number is the number of reads and the second is the number of subjects
	nrs <- rep(10000, 2)
	
	gendata <- generateTree(saliva, nrs)
}