% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI.R
\name{CI_tp}
\alias{CI_tp}
\title{Global confidence interval treshold from experimental standard deviation}
\usage{
CI_tp(df, replicates = 3, alpha = 0.01)
}
\arguments{
\item{df}{standard deviation dataframe.}

\item{replicates}{number of replicates. Default set to 3.}

\item{alpha}{significance level. Set as default to 0.01}
}
\value{
treshold for determining significance.
}
\description{
Calculation of global confidence interval using approach by for all protein states compared to first state in the data.frame.
Reliable Identification of Significant Differences in Differential Hydrogen Exchange-Mass Spectrometry Measurements Using a Hybrid Significance Testing Approach
Tyler S. Hageman and David D. Weis
Analytical Chemistry 2019 91 (13), 8008-8016 DOI: 10.1021/acs.analchem.9b01325
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tc(file_nm, seq_match=FALSE)
sd<-sd_timepoint(df=a, replicates=3)
CI_tp(df=sd, replicates=3, alpha=0.01 )
CI_tp(sd)
}
