% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EqualAreaRectangle.R
\name{EqualAreaRectangle}
\alias{EqualAreaRectangle}
\title{Create a rectangular shaped distribution with equal area to a given area}
\usage{
EqualAreaRectangle(center = c(0, 0), TargetArea, error = 0.001)
}
\arguments{
\item{center}{- Arrary containing the coordinates of the center of circular portion of the rectangle in decimal degree}

\item{TargetArea}{- Area in square kilometers desired for the rectangle}

\item{error}{- The tolerable proportion of error between the rectangular shape and the TargetArea}
}
\value{
Returns a 2-dimensional array of decimal degree coordinates outlining a rectangular shaped distribution
}
\description{
Create a rectangular shaped distribution with equal area to a given area
}
\note{
This returns 100 evenly spaced points along each corner of the rectangle, in addition to the corners themselves
}
\examples{
HorseShoeTest<-PtsAlgHorseShoe(z=2000,spacing=1,endAngles=c(-90,90))
HorseShoePts<-RandHorseShoe(center=c(0,0),npts=100,HorseShoeShape=HorseShoeTest)
EqualAreaRectangle(TargetArea=as.numeric(HorseShoePts$TotalArea_km2),error=0.001)
}
