% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordCollapse.R
\name{CoordCollapse}
\alias{CoordCollapse}
\title{Removes duplicate geographic locations and binds coordinates into a single element}
\usage{
CoordCollapse(longs, lats)
}
\arguments{
\item{longs}{- Longitudinal coordinates of occurrences in decimal degrees}

\item{lats}{- Latitudinal coordinates of occurrences in decimal degrees}
}
\value{
Returns a 2-column array of coordinates without any duplicate locations
}
\description{
Removes duplicate geographic locations and binds coordinates into a single element
}
\note{
Points are truncated to the hundredths place before checking for duplicates
}
\examples{
longs<-c(34,133,-45)
lats<-c(-12,44,76)
CoordCollapse(longs,lats)
}
