% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{cons.MatC}
\alias{cons.MatC}
\title{Construct covariance matrix C for model averaging SE}
\usage{
cons.MatC(mywt, cov22, quant)
}
\arguments{
\item{mywt}{Weight computation result list from \code{weight.com()}.}

\item{cov22}{Array of 2x2 covariance matrices for each submodel (2 x 2 x numk).}

\item{quant}{Numeric vector of quantile probabilities.}
}
\value{
A list containing:
\describe{
  \item{MatC}{Array (numk x numk x numq) of cross-covariance values}
  \item{fin.se}{SE under fixed weights for MA}
  \item{fin.se.bma}{SE under fixed weights for BMA}
  \item{numk}{Number of submodels}
  \item{numq}{Number of quantiles}
  \item{wtgd}{MA weights}
  \item{bmaw}{BMA weights}
}
}
\description{
Internal function that constructs the cross-covariance matrix
between submodel quantile estimators using the delta method and quantile
correlation approximation.
}
\keyword{internal}
