% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnn.plot.R
\name{fnn.plot}
\alias{fnn.plot}
\title{Plotting Functional Response Predictions}
\usage{
fnn.plot(
  FNN_Predict_Object,
  Basis_Type = "fourier",
  domain_range = c(0, 1),
  step_size = 0.01
)
}
\arguments{
\item{FNN_Predict_Object}{An object output by the \code{fnn.predict()} function. Must be for when the problem is that of
a functional response.}

\item{Basis_Type}{The type of basis to use to create the functional response.}

\item{domain_range}{The continuum range of the functional responses.}

\item{step_size}{The size of the movement from the lower bound of the \code{domanin_range} to the upper bound.}
}
\value{
The following are returned:

\code{plot} -- A \code{ggplot()} object of the predicted functional responses.

\code{evaluations} -- The discrete evaluations across the domain of the functional response.
}
\description{
This function is to be used for functional responses. It outputs a \code{ggplot()} object of the predicted functional responses.
}
\details{
No additional details for now.
}
\examples{
\donttest{
# libraries
library(fda)

# Loading data
data("daily")

# Creating functional data
temp_data = array(dim = c(65, 35, 1))
tempbasis65  = create.fourier.basis(c(0,365), 65)
tempbasis7 = create.bspline.basis(c(0,365), 7, norder = 4)
timepts = seq(1, 365, 1)
temp_fd = Data2fd(timepts, daily$tempav, tempbasis65)
prec_fd = Data2fd(timepts, daily$precav, tempbasis7)
prec_fd$coefs = scale(prec_fd$coefs)

# Data set up
temp_data[,,1] = temp_fd$coefs
resp_mat = prec_fd$coefs

# Non functional covariate
weather_scalar = data.frame(total_prec = apply(daily$precav, 2, sum))

# Splitting into test and train
ind = 1:30
nbasis = 65
weather_data_train <- array(dim = c(nbasis, length(ind), 1))
weather_data_test <- array(dim = c(nbasis, ncol(daily$tempav) - length(ind), 1))
weather_data_train[,,1] = temp_data[, ind, ]
weather_data_test[,,1] = temp_data[, -ind, ]
scalar_train = data.frame(weather_scalar[ind,1])
scalar_test = data.frame(weather_scalar[-ind,1])
resp_train = t(resp_mat[,ind])
resp_test = t(resp_mat[,-ind])

# Running model
weather_func_fnn <- fnn.fit(resp = resp_train,
                            func_cov = weather_data_train,
                            scalar_cov = scalar_train,
                            basis_choice = c("bspline"),
                            num_basis = c(7),
                            hidden_layers = 2,
                            neurons_per_layer = c(1024, 1024),
                            activations_in_layers = c("sigmoid", "linear"),
                            domain_range = list(c(1, 365)),
                            epochs = 300,
                            learn_rate = 0.01,
                            func_resp_method = 1)

# Getting predictions
predictions = fnn.predict(weather_func_fnn,
                          weather_data_test,
                          scalar_cov = scalar_test,
                          basis_choice = c("bspline"),
                          num_basis = c(7),
                          domain_range = list(c(1, 365)))

# Looking at plot
fnn.plot(predictions, domain_range = c(1, 365), step_size = 1, Basis_Type = "bspline")
}

}
