% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fbdrange.R
\name{plot.fbdrange}
\alias{plot.fbdrange}
\title{Plot oriented tree with stratigraphic ranges}
\usage{
\method{plot}{fbdrange}(x, smart.labels = FALSE, ...)
}
\arguments{
\item{x}{object of type \code{fbdrange} containing orientation and range data}

\item{smart.labels}{whether to label the ranges (default \code{FALSE}, requires package [ggrepel] to place labels)}

\item{...}{other arguments to be passed to the plot labels (does nothing if \code{smart.labels = FALSE})}
}
\value{
a ggtree plot which can be combined with any other commands from [ggplot2] or [ggtree]
}
\description{
Plot oriented tree with stratigraphic ranges
}
\examples{
tree_file <- system.file("extdata", "fbdrange.trees", package = "FossilSim")
fbdr <- get_fbdrange_from_file(tree_file)
p <- plot(fbdr, smart.labels = TRUE)

}
