% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindOutliers.R
\name{FindOutliers}
\alias{FindOutliers}
\title{Find outliers by three methods}
\usage{
FindOutliers(x, method, t = NULL)
}
\arguments{
\item{x}{numerical vector in which outliers are to be detected}

\item{method}{single character specifying the outlier rule (T, H, or B)}

\item{t}{threshold parameter (default NULL, gives 3 for T and H rules, 1.5 for B rule)}
}
\value{
index into elements of \code{x} identified as outliers
}
\description{
Returns an index into outlying points, if any, identified by one of
three outlier detection rules: the three-sigma edit rule, the Hampel
identifier, or the boxplot rule
}
\examples{
x <- seq(-1, 1, length = 100)
x[1:10] <- 10
Tindex <- FindOutliers(x, "T")
x[Tindex]  # Example where the three-sigma rule fails
Hindex <- FindOutliers(x, "H")
x[Hindex]
Bindex <- FindOutliers(x, "B")
x[Bindex]
}
