#' Dataset with missing values and other special cases
#'
#' Small dataset illustrating standard missing values (NA and NaN),
#' blanks, spaces, and other values sometimes used to represent
#' missing data (e.g., blanks, spaces, and zeros)
#'
#' @format ## `FirstAnomalyDataFrame`
#' a data frame with 5 rows and 6 columns:
#' \describe{
#'   \item{NumVar1}{numerical variable with positive, zero, negative and missing (NA) values}
#'   \item{NumVar2}{numerical variable with positive, zero, and missing (NA) values}
#'   \item{NumVar3}{the ratio of `NumVar1` to `NumVar2`}
#'   \item{CatVar1}{categorical variable with missing data represented as NA}
#'   \item{CatVar2}{categorical variable with missing data represented with blanks or spaces}
#'   \item{CatVar3}{categorical variable with missing data represented with multiple spaces}
#' }
"FirstAnomalyDataFrame"
#' Synthetic accounting dataset example, from Excel
#'
#' Small dataset illustrating various unexpected data formats arising
#' from the accounting data format in an Excel spreadsheet.  Variables
#' that appear to be numeric based on the name are represented as
#' character strings with embedded commas, dollar signs, percent signs,
#' and parentheses to indicate negative numbers
#'
#' @format ## `AccountingExample`
#' data frame with 8 rows and 6 columns:
#' \describe{
#'   \item{Year}{Four-digit integer year, with missing values coded NA}
#'   \item{Quarter}{Two-character quarter designation, Q1 through Q4}
#'   \item{CurrentTotal}{Dollar amount with dollar signs, commas, and decimal points}
#'   \item{PriorYearTotal}{Dollar amount with dollar signs, commas, and decimal points}
#'   \item{YOYchange}{Dollar amount with dollar signs, commas, decimal points and parentheses to indicate negative values}
#'   \item{PctChange}{Ratio of YOYchange to CurrentTotal, converted to a percentage, with percent sign}
#' }
"AccountingExample"
