% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson.R
\name{poisson_test_pv}
\alias{poisson_test_pv}
\alias{poisson.test.pv}
\title{Poisson Test}
\usage{
poisson_test_pv(
  x,
  lambda = 1,
  alternative = "two.sided",
  ts_method = "minlike",
  exact = TRUE,
  correct = TRUE,
  simple_output = FALSE
)

poisson.test.pv(
  x,
  lambda = 1,
  alternative = "two.sided",
  ts.method = "minlike",
  exact = TRUE,
  correct = TRUE,
  simple.output = FALSE
)
}
\arguments{
\item{x}{integer vector giving the number of events.}

\item{lambda}{non-negative numerical vector of hypothesised rate(s).}

\item{alternative}{character vector that indicates the alternative hypotheses; each value must be one of \code{"two.sided"} (the default), \code{"less"} or \code{"greater"}.}

\item{ts_method, ts.method}{single character string that indicates the two-sided p-value computation method (if any value in \code{alternative} equals \code{"two.sided"}) and must be one of \code{"minlike"} (the default), \code{"blaker"}, \code{"absdist"} or \code{"central"} (see details). Ignored, if \code{exact = FALSE}.}

\item{exact}{logical value that indicates whether p-values are to be calculated by exact computation (\code{exact = TRUE}; the default) or by a continuous approximation.}

\item{correct}{logical value that indicates if a continuity correction is to be applied (\code{correct = TRUE}; the default) or not. Ignored, if \code{exact = TRUE}.}

\item{simple_output, simple.output}{logical value that indicates whether an R6 class object, including the tests' parameters and support sets, i.e. all observable p-values under each null hypothesis, is to be returned (see below).}
}
\value{
If \code{simple.output = TRUE}, a vector of computed p-values is returned.
Otherwise, the output is a \code{\link{DiscreteTestResults}} R6 class object, which
also includes the p-value supports and testing parameters. These have to be
accessed by public methods, e.g. \verb{$get_pvalues()}.
}
\description{
\code{poisson_test_pv()} performs an exact or approximate Poisson test about the
rate parameter of a Poisson distribution. In contrast to
\code{\link[stats:poisson.test]{stats::poisson.test()}}, it is vectorised, only calculates p-values and
offers a normal approximation of their computation. Furthermore, it is
capable of returning the discrete p-value supports, i.e. all observable
p-values under a null hypothesis. Multiple tests can be evaluated
simultaneously. In two-sided tests, several procedures of obtaining the
respective p-values are implemented.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr
\strong{Note}: Please use \code{poisson_test_pv()}! The older \code{poisson.test.pv()} is
deprecated in order to migrate to snake case. It will be removed in a future
version.
}
\details{
The parameters \code{x}, \code{lambda} and \code{alternative} are vectorised. They are
replicated automatically to have the same lengths. This allows multiple null
hypotheses to be tested simultaneously.

Since the Poisson distribution itself has an infinite support, so do the
p-values of exact Poisson tests. Thus supports only contain p-values that
are not rounded off to 0.

For exact computation, various procedures of determining two-sided p-values
are implemented.
\describe{
\item{\code{"minlike"}}{The standard approach in \code{\link[stats:fisher.test]{stats::fisher.test()}} and
\code{\link[stats:binom.test]{stats::binom.test()}}. The probabilities of the
likelihoods that are equal or less than the observed one
are summed up. In Hirji (2006), it is referred to as the
\emph{Probability-based} approach.}
\item{\code{"blaker"}}{The minima of the observations' lower and upper tail
probabilities are combined with the opposite tail not
greater than these minima. More details can be found in
Blaker (2000) or Hirji (2006), where it is referred to as
the \emph{Combined Tails} method.}
\item{\code{"absdist"}}{The probabilities of the absolute distances from the
expected value that are greater than or equal to the
observed one are summed up. In Hirji (2006), it is
referred to as the \emph{Distance from Center} approach.}
\item{\code{"central"}}{The smaller values of the observations' simply doubles
the minimum of lower and upper tail probabilities. In
Hirji (2006), it is referred to as the \emph{Twice the
Smaller Tail} method.}
}
For non-exact (i.e. continuous approximation) approaches, \code{ts_method} is
ignored, since all its methods would yield the same p-values. More
specifically, they all converge to the doubling approach as in
\code{ts_mthod = "central"}.
}
\examples{
# Constructing
k <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
lambda <- c(3, 2, 1)

# Computation of exact two-sided p-values ("blaker") and their supports
results_ex  <- poisson_test_pv(k, lambda, ts_method = "blaker")
raw_pvalues <- results_ex$get_pvalues()
pCDFlist    <- results_ex$get_pvalue_supports()

# Computation of normal-approximated one-sided p-values ("less") and their supports
results_ap  <- poisson_test_pv(k, lambda, "less", exact = FALSE)
raw_pvalues <- results_ap$get_pvalues()
pCDFlist    <- results_ap$get_pvalue_supports()

}
\references{
Blaker, H. (2000) Confidence curves and improved exact confidence intervals
for discrete distributions. \emph{Canadian Journal of Statistics},
\strong{28}(4), pp. 783-798. \doi{10.2307/3315916}

Hirji, K. F. (2006). \emph{Exact analysis of discrete data}. New York: Chapman
and Hall/CRC. pp. 55-83. \doi{10.1201/9781420036190}
}
\seealso{
\code{\link[stats:poisson.test]{stats::poisson.test()}}, \code{\link[=binom_test_pv]{binom_test_pv()}}
}
