% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{procrustes}
\alias{procrustes}
\title{Procrustes Transformation}
\usage{
procrustes(X, Y)
}
\arguments{
\item{X}{The target configuration.}

\item{Y}{The configuration to be aligned to X.}
}
\value{
The transformed version of Y aligned to X.
}
\description{
Aligns a given object configuration to a target object configuration using a Procrustes transformation.
}
\details{
This function performs a Procrustes transformation to align a given configuration, \code{Y}, to the target configuration, \code{X}, using a combination of translation and rotation. The transformation aims to minimize the sum of squared differences between the two configurations.

\code{X} and \code{Y} should be numeric matrices of the same dimension.
}
\examples{
X <- matrix(rnorm(20), ncol = 2)
rotation_matrix <- matrix(c(cos(pi/4), -sin(pi/4), sin(pi/4), cos(pi/4)), ncol = 2)
Y <- X \%*\% rotation_matrix + 2
Y_transformed <- procrustes(X, Y)
}
