% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getBaseType}
\alias{getBaseType}
\title{Retrieve data items by baseType}
\usage{
getBaseType(dgeObj, baseType)
}
\arguments{
\item{dgeObj}{A class DGEobj created by function initDGEobj()}

\item{baseType}{One or more of: ["row", "col", "assay", "meta"]}
}
\value{
A list of data items
}
\description{
Retrieve data items by baseType
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("miniObj.RDS", package = "DGEobj"))

    Assays <- getBaseType(exObj, baseType = "assay")
    AssaysAndMeta <- getBaseType(exObj, c("assay", "meta"))

}
