% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{normalize_function}
\alias{normalize_function}
\title{normalize_function}
\usage{
normalize_function(method = EnumEvalMethod, norm = NULL)
}
\arguments{
\item{method}{One of: \code{"set"} (default), \code{"prob"}, \code{"fuzzy"} or \code{"fuzzynorm"}.}

\item{norm}{Some normalization function of the form \verb{function(num_vector)}, or \code{NULL}.}
}
\value{
Returns function \code{norm} if not \code{NULL}.
Otherwise, it determines the result depending on \code{method}:
\describe{
\item{\code{"set"}:}{\code{\link[=norm_none]{norm_none()}}}
\item{\code{"prob"}:}{\code{\link[=norm_sum]{norm_sum()}}}
\item{\code{"fuzzy"}:}{\code{\link[=norm_none]{norm_none()}}}
\item{\code{"fuzzynorm"}:}{\code{\link[=norm_max]{norm_max()}}}
}
Fails with an error if the result is not an R function.
}
\description{
Determine the function to be used in the normalization step of \code{\link[=evaluate]{evaluate()}}.
}
\seealso{
\code{\link[DEXiR]{evaluate}}, \code{\link[=norm_none]{norm_none()}}, \code{\link[=norm_max]{norm_max()}}, \code{\link[=norm_sum]{norm_sum()}},
}
\concept{"normalize functions"}
