% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{convert_data_continuous}
\alias{convert_data_continuous}
\title{convert_data_continuous}
\usage{
convert_data_continuous(
  data,
  scale,
  imin = NULL,
  imax = NULL,
  omin = 0,
  omax = 1,
  map_values = TRUE,
  reverse_descending = TRUE
)
}
\arguments{
\item{data}{A vector containing floating point numbers.
Typically a \code{data.frame} column of DEXi alternatives' data.}

\item{scale}{A \link{DexiContinuousScale} object or a continuous \link{DexiAttribute} object.}

\item{imin}{Lower input bound. Default: determined as \code{min(data)}.}

\item{imax}{Upper input bound. Default: determined as \code{max(data)}.}

\item{omin}{Lower output bound for \code{\link[=lin_map]{lin_map()}} value scaling.}

\item{omax}{Upper output bound for \code{\link[=lin_map]{lin_map()}} value scaling.}

\item{map_values}{\code{logical(1)}. Whether or not to perform value scaling using \code{\link[=lin_map]{lin_map()}}.}

\item{reverse_descending}{\code{logical(1)}. Whether or not to reverse values of a "descending" scale.}
}
\value{
\code{numeric()}. Vector of converted values.
}
\description{
A helper function for converting individual columns of alternatives' data.
It is assumed that \code{data}  contains numeric data corresponding to a continuous
\link{DexiAttribute}. During conversion,
values are optionally converted from some interval to another, using \code{\link[=lin_map]{lin_map()}}, and/or
reversed using \code{\link[=reverse_value]{reverse_value()}} for scales whose \verb{$order = "descending"}.
}
\examples{
scl <- DexiContinuousScale()
convert_data_continuous(c(1, 2, 5), scl) # c(0.0, 0.25, 1.00)
convert_data_continuous(c(1, 2, 5), scl, imin = 0, imax = 10, omin = 0, omax = 100)
# c(10, 20, 50)

}
\seealso{
\code{\link[=lin_map]{lin_map()}}, \code{\link[=reverse_value]{reverse_value()}}
}
