% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{compare_values_by_preference}
\alias{compare_values_by_preference}
\title{compare_values_by_preference}
\usage{
compare_values_by_preference(value1, value2, order = EnumOrder)
}
\arguments{
\item{value1}{First value.}

\item{value2}{Second value.}

\item{order}{\code{EnumOrder}, i.e., one of the strings \verb{"ascending", "descending", "none"}.}
}
\value{
\code{\link[=compare_values]{compare_values()}} result, modified according to \code{order}.
Results \code{0} (equal values) and \code{NA} (incomparable values) are always retained.
Results \code{-1} and \code{+1} are retained when \code{order="ascending"} and
reversed when \code{order="descending"}.
When \code{order="none"}, non-equal values return \code{NA}.
}
\description{
Compare values, considering preference \code{order}. For value arguments, see \code{\link[=compare_values]{compare_values()}}.
}
\examples{
compare_values_by_preference(1, 1, "none")       # 0
compare_values_by_preference(1, 2, "none")       # NA
compare_values_by_preference(3, 2, "none")       # NA
compare_values_by_preference(1, 1, "ascending")  # 0
compare_values_by_preference(1, 2, "ascending")  # -1
compare_values_by_preference(3, 2, "ascending")  # +1
compare_values_by_preference(1, 1, "descending") # 0
compare_values_by_preference(1, 2, "descending") # +1
compare_values_by_preference(3, 2, "descending") # -1
}
\seealso{
\code{\link[=compare_values]{compare_values()}}
}
