% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{filter_debris_cytof}
\alias{filter_debris_cytof}
\title{Flag debris in mass cytometry data.}
\usage{
filter_debris_cytof(
  df,
  cols,
  cols_plot = c("DNA1", "CD45"),
  cofactor = 5,
  threshold = 0.3
)
}
\arguments{
\item{df}{A data frame containing protein expression data.}

\item{cols}{Columns to use in analysis. It is recommended to use the same
ones in the call to cleanet.}

\item{cols_plot}{Two columns that are used for visual feedback.}

\item{cofactor}{Parameter for arcsinh transformation used before computing
distances. 5 is a good default for mass cytometry data.}

\item{threshold}{Number between 0 and 1; distances are scaled between
0 and 1 and events whose distance to the origin is smaller than the
threshold are flagged.}
}
\value{
A binary array with the same length as the number of rows in df.
TRUE for debris, FALSE for everything else.
}
\description{
Detect events with low distance from 0 in protein space.
This function aims for high specificity, but not high sensitivity: for
Cleanet's purposes, it suffices to deplete debris, even if not all of
it is eliminated.
}
\examples{
path <- system.file("extdata", "df_mdipa.csv", package="Cleanet")
df_mdipa <- read.csv(path, check.names=FALSE)
cols <- c("CD45", "CD123", "CD19", "CD11c", "CD16",
          "CD56", "CD294", "CD14", "CD3", "CD20",
          "CD66b", "CD38", "HLA-DR", "CD45RA",
          "DNA1", "DNA2")
is_debris <- filter_debris_cytof(df_mdipa, cols)
}
