% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_coef_change.R
\name{check_coef_change}
\alias{check_coef_change}
\title{Assess Coefficient Change After Variable Removal}
\usage{
check_coef_change(data, yval, xpre, xcheck, strata = NULL)
}
\arguments{
\item{data}{A data frame containing the outcome, predictors, and optional stratification variable.}

\item{yval}{A string naming the binary outcome variable.}

\item{xpre}{A character vector of variable names that are already selected for the model.}

\item{xcheck}{A character vector of variable names to be added one-by-one for comparison.}

\item{strata}{Optional; a string specifying the name of the stratification variable for conditional logistic regression.}
}
\value{
A data frame showing how the coefficients change when each variable in \code{xcheck}
is added to the model containing \code{xpre}.
}
\description{
Computes the percentage change in logistic regression coefficients (\eqn{\Delta \hat{\beta}\%}) as each additional variable is introduced
to the model one at a time.
Supports both standard logistic regression (via \code{glm}) and conditional logistic regression (via \code{clogit}) when a stratification variable is provided.
}
\details{
This function fits a logistic regression model using variables in \code{xpre},
and then adds each variable in \code{xcheck} one at a time to assess how the coefficients
of the model change with the delta beta hat percentages. Useful for evaluating confounding or additional variable contribution.
When \code{strata} is \code{NULL}, the function uses standard logistic regression (\code{glm} with binomial family).
When \code{strata} is specified, conditional logistic regression is used instead via \code{survival::clogit}.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 4

# Variables selected to evaluate
preliminar <- c('age', 'height', 'priorfrac', 'momfrac', 'armassist')

# Variable to evaluate for potential confounding
excluded <- c('raterisk')

# Assess coefficient change after adding 'raterisk'
check_coef_change(data = glow500, yval = 'fracture', xpre = preliminar, xcheck = excluded)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression}
(3rd ed.). John Wiley & Sons, Inc. The formulas for calculating residuals and diagnostics are adapted from this source.
}
\seealso{
\code{\link{delta.coefficient}}
}
