% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEEMDANML.R
\name{carigaan}
\alias{carigaan}
\title{CEEMDAN Decomposition-Based ARIMA-GARCH-ANN Hybrid Modeling}
\usage{
carigaan(Y, ratio = 0.9, n_lag = 4)
}
\arguments{
\item{Y}{Univariate time series}

\item{ratio}{Ratio of number of observations in training and testing sets}

\item{n_lag}{Lag of the provided time series data}
}
\value{
\itemize{
  \item Train_fitted: Train fitted result
  \item Test_predicted: Test predicted result
  \item Accuracy: Accuracy
  }
}
\description{
CEEMDAN Decomposition-Based ARIMA-GARCH-ANN Hybrid Modeling
}
\examples{
Y <- rnorm(100, 100, 10)
result <- carigaan(Y, ratio = 0.8, n_lag = 4)
}
\references{
\itemize{
  \item Garai, S., & Paul, R. K. (2023). Development of MCS based-ensemble models using CEEMDAN decomposition and machine intelligence. Intelligent Systems with Applications, 18, 200202
  \item Garai, S., Paul, R. K., Rakshit, D., Yeasin, M., Paul, A. K., Roy, H. S., Barman, S. & Manjunatha, B. (2023). An MRA Based MLR Model for Forecasting Indian Annual Rainfall Using Large Scale Climate Indices. International Journal of Environment and Climate Change, 13(5), 137-150.
  }
}
