% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{leukemia_small}
\alias{leukemia_small}
\title{Leukemia Gene Expression Data (Small)}
\format{
A data frame with 3571 rows (genes) and 72 columns (patients). Column names
indicate the class label (ALL or AML) for each patient.
}
\source{
\url{https://hastie.su.domains/CASI_files/DATA/leukemia_small.csv}
}
\description{
Gene expression measurements on 72 leukemia patients: 47 ALL (acute lymphoblastic
leukemia) and 25 AML (acute myeloid leukemia). From the landmark Golub et al. (1999)
Science paper. This smaller subset contains 3571 genes and is used in Section 19.1.
}
\details{
A larger dataset with 7128 genes is also available from the CASI website.
}
\examples{
data(leukemia_small)
str(leukemia_small)
}
\references{
Golub, T.R., et al. (1999). Molecular Classification of Cancer: Class Discovery
and Class Prediction by Gene Expression Monitoring. \emph{Science}, 286, 531-537.

Efron, B. and Hastie, T. (2016). \emph{Computer Age Statistical Inference}.
Cambridge University Press, Section 19.1.
}
