% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{als}
\alias{als}
\title{ALS Data}
\format{
A data frame with 1822 rows and 371 variables. The key variables are
\code{testset} (logical indicator for training/test split) and \code{dFRS}
(response: rate of progression of the ALS functional rating score). The 369
predictor variables include:
\itemize{
\item Demographics: \code{Age}, \code{Sex.Male}, \code{Sex.Female}, and
race indicators (\code{Race...Caucasian}, \code{Race...Asian}, etc.)
\item Family history of neurological diseases in relatives (e.g.,
\code{Father}, \code{Mother}, \code{Brother}, \code{Sister})
\item Neurological disease indicators (e.g., \code{Neurological.Disease.ALS},
\code{Neurological.Disease.PARKINSON.S.DISEASE})
\item Site of onset (\code{Site.of.Onset.Onset..Bulbar},
\code{Site.of.Onset.Onset..Limb})
\item Symptoms (\code{Symptom.Atrophy}, \code{Symptom.Cramps},
\code{Symptom.Fasciculations}, \code{Symptom.Speech}, etc.)
\item Study arm indicators (\code{Study.Arm.ACTIVE}, \code{Study.Arm.PLACEBO})
\item Clinical measurements with summary statistics (first, last, min, max,
mean, sd, slope): ALSFRS scores, blood pressure, forced/slow vital capacity
(\code{fvc.liters}, \code{svc.liters}), respiratory rate, weight, height
\item ALSFRS subscale items: \code{climbing.stairs}, \code{cutting},
\code{dressing}, \code{handwriting}, \code{salivation}, \code{speech},
\code{swallowing}, \code{turning}, \code{walking}
}
}
\source{
\url{https://hastie.su.domains/CASI_files/DATA/ALS.txt}
}
\description{
Data on amyotrophic lateral sclerosis (Lou Gehrig's disease) from Section 17.2.
There are 1822 observations on individuals with ALS. The goal is to predict the
rate of progression dFRS of a functional rating score, using 369 predictors based
on measurements (and derivatives of these) obtained from patient visits.
}
\details{
These data were kindly provided by Lester Mackey and Lilly Fang, who won the
DREAM challenge prediction prize in 2012 (Kuffner et al., 2015). It includes
some additional variables created by them. Their winning entry used Bayesian
trees, not too different from random forests.
}
\examples{
data(als)
str(als)
}
\references{
Efron, B. and Hastie, T. (2016). \emph{Computer Age Statistical Inference}.
Cambridge University Press, Section 17.2.
}
