% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{cut_perf}
\alias{cut_perf}
\title{Cutoff Performance Evaluation}
\usage{
cut_perf(
  yvar,
  censorvar = NULL,
  xvar,
  cutoff,
  dir,
  xvars.adj = NULL,
  data,
  type,
  yvar.display = yvar,
  xvar.display = xvar
)
}
\arguments{
\item{yvar}{Response variable name.}

\item{censorvar}{Censoring variable name (0-censored, 1-event).}

\item{xvar}{Biomarker name.}

\item{cutoff}{Selected cutoff value.}

\item{dir}{Direction for desired subgroup (">", ">=", "<", "<=").}

\item{xvars.adj}{Other covariates to adjust when evaluating the performance.}

\item{data}{Data frame containing the variables.}

\item{type}{Type of analysis: "c" for continuous, "s" for survival, and "b" for binary.}

\item{yvar.display}{Display name of response variable.}

\item{xvar.display}{Display name of biomarker variable.}
}
\value{
A list containing various performance metrics and optionally, plots.
}
\description{
This function evaluates the performance of a predictive model at a selected cutoff point.
}
\examples{
# Load a sample dataset
data <- data.frame(
  survival_time = rexp(100, rate = 0.1),  # survival time
  status = sample(c(0, 1), 100, replace = TRUE),  # censoring status
  biomarker = rnorm(100, mean = 0, sd = 1),  # biomarker levels
  covariate1 = rnorm(100, mean = 50, sd = 10)  # an additional covariate
)
# Perform cutoff performance evaluation for continuous outcome
data$continuous_outcome <- rnorm(100, mean = 10, sd = 5)
cut_perf(
  yvar = "continuous_outcome",
  xvar = "biomarker",
  cutoff = 0.5,
  dir = ">=",
  data = data,
  type = "c",
  yvar.display = "Continuous Outcome",
  xvar.display = "Biomarker Level"
)

# Perform cutoff performance evaluation for binary outcome
data$binary_outcome <- sample(c(0, 1), 100, replace = TRUE)
cut_perf(
  yvar = "binary_outcome",
  xvar = "biomarker",
  cutoff = 0,
  dir = "<=",
  data = data,
  type = "b",
  yvar.display = "Binary Outcome",
  xvar.display = "Biomarker Level"
)
}
