% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdWriteDiagonal_hdf5}
\alias{bdWriteDiagonal_hdf5}
\title{Write Matrix Diagonal to HDF5}
\usage{
bdWriteDiagonal_hdf5(diagonal, filename, group, dataset)
}
\arguments{
\item{diagonal}{Numeric vector. New diagonal elements to write.}

\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Path to the group containing the dataset.}

\item{dataset}{Character string. Name of the dataset to modify.}
}
\value{
List with components. If an error occurs, all string values are returned as empty strings (""):
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the diagonal elements written (group/dataset)}
}
}
\description{
Updates the diagonal elements of a matrix stored in an HDF5 file.
}
\details{
This function provides efficient diagonal modification capabilities with:
\itemize{
\item Write features:
\itemize{
\item Direct diagonal access
\item Type checking and validation
\item Support for large matrices
}
\item Implementation features:
\itemize{
\item Safe HDF5 file operations
\item Memory-efficient implementation
\item Comprehensive error handling
\item Type conversion support
}
}

The function validates input types and dimensions before modification.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test matrix
X <- matrix(rnorm(100), 10, 10)

# Save to HDF5
bdCreate_hdf5_matrix("test.hdf5", X, "data", "matrix1",
                     overwriteFile = TRUE)

# Create new diagonal
new_diag <- seq(1, 10)

# Update diagonal
bdWriteDiagonal_hdf5(new_diag, "test.hdf5", "data", "matrix1")

# Verify
diag_elements <- bdgetDiagonal_hdf5("test.hdf5", "data", "matrix1")
print(diag_elements)

# Cleanup
if (file.exists("test.hdf5")) {
  file.remove("test.hdf5")
}
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
}
}
\seealso{
\itemize{
\item \code{\link{bdgetDiagonal_hdf5}} for reading diagonal elements
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices
}
}
