% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{massprop_skin}
\alias{massprop_skin}
\title{Calculates the mass properties of skin or tertiaries}
\usage{
massprop_skin(m, rho, pts)
}
\arguments{
\item{m}{Mass of skin (kg)}

\item{rho}{Density of skin (kg/m^3)}

\item{pts}{a 3x3 matrix that represent three points that define the
vertices of the triangle. Frame of reference: VRP | Origin: VRP
Must be numbered in a counterclockwise direction for positive area,
otherwise signs will be reversed.
each point should be a different of the matrix as follows:
\itemize{
\item{pt1x, pt1y, pt1z}
\item{pt2x, pt1y, pt2z}
\item{pt3x, pt3y, pt3z}
}}
}
\value{
This function returns a list that includes:
point mass
\itemize{
\item{I}{a 3x3 matrix representing the moment of inertia tensor of skin
modeled as a flat triangular plate}
\item{CG}{a 1x3 vector representing the center of gravity position of skin
modeled as a flat triangular plate}
\item{m}{a double that returns the input skin mass}
}
}
\description{
Calculate the moment of inertia of skin or tertiaries modeled as a
flat triangular plate
}
\section{Warning}{

Parallel axis theorem does not apply between two arbitrary points.
One point must be the object's center of gravity.

Caution: The skin frame of reference assumes that the z axis is normal
to the incoming points.
}

\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
