% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{compute_auc_val_ord}
\alias{compute_auc_val_ord}
\title{Internal function: Compute mean AUC for ordinal outcomes based on
  validation set for plotting parsimony}
\usage{
compute_auc_val_ord(
  train_set_1,
  validation_set_1,
  variable_list,
  link,
  categorize,
  quantiles,
  max_cluster,
  max_score
)
}
\arguments{
\item{train_set_1}{Processed training set}

\item{validation_set_1}{Processed validation set}

\item{variable_list}{List of included variables}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{categorize}{Methods for categorize continuous variables. Options include "quantile" or "kmeans"}

\item{quantiles}{Predefined quantiles to convert continuous variables to categorical ones. Available if \code{categorize = "quantile"}.}

\item{max_cluster}{The max number of cluster (Default: 5). Available if \code{categorize = "kmeans"}.}

\item{max_score}{Maximum total score}
}
\value{
A list of mAUC for parsimony plot
}
\description{
Compute mean AUC based on validation set for plotting parsimony
}
