% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelDerivative.R
\name{getMetadata}
\alias{getMetadata}
\title{Get the Metadata for a File.}
\usage{
getMetadata(urn = NULL, token = NULL)
}
\arguments{
\item{urn}{A string. Source URN (objectId) for the file. Note the URN must be
Base64 encoded. To encode the URN, see, for example, the
\code{jsonlite::base64_enc} function.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{data:read} and \code{data:write} scopes.}
}
\value{
An object containing the \code{type}, \code{name}, and \code{guid} of
  the file.
}
\description{
Get the metadata of an uploaded file using the Model Derivative API.
}
\examples{
\dontrun{
# Get the metadata for the "aerial.dwg" svf file
resp <- getMetadata(urn <- myEncodedUrn, token = myToken)
myGuid <- resp$content$data$metadata[[1]]$guid
}
}
