% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_configuration.r
\name{simpleSysConfig}
\alias{simpleSysConfig}
\title{Function to generate a simple Amiga system-configuration representation}
\usage{
simpleSysConfig(options)
}
\arguments{
\item{options}{A named \code{list} with elements of the target
\code{\link[=SysConfig]{SysConfig()}} object that need to be modified.}
}
\value{
Returns a comprehensive representation of a system-configuration file in the
for of a \link{SysConfig} class object.
}
\description{
\link{SysConfig} objects are comprehensive representations of binary Amiga
system-configuration files. Use this function to create a simple \link{SysConfig} object.
}
\details{
The Amiga used the system-configuration file to store certain system preferences
in a binary file. In the AmigaFFH package such files can be represented by the more
comprehensive \link{SysConfig} class object. Use this function to create such an object
with basic settings (which can be modified).
}
\examples{
## Create a simple system-configuration (S3 SysConfigClass)
sc <- simpleSysConfig()

## And modify it as you wish.
## in this case change the setting for the printer
## from the parallel port to the serial port:
sc$PrinterPort <- factor("SERIAL_PRINTER", levels(sc$PrinterPort))

## It is also to provide modifications to the configuration
## via the 'options' argument:
sc <- simpleSysConfig(options = list(FontHeight = 9))
}
\seealso{
Other SysConfig.operations: 
\code{\link{SysConfig}},
\code{\link{rawToSysConfig}()},
\code{\link{read.SysConfig}()},
\code{\link{write.SysConfig}()}
}
\author{
Pepijn de Vries
}
\concept{SysConfig.operations}
