% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{as.AmigaBasicBMAP}
\alias{as.AmigaBasicBMAP}
\title{Coerce raw or named list to an AmigaBasicBMAP class object}
\usage{
as.AmigaBasicBMAP(x)
}
\arguments{
\item{x}{When \code{x} is a \code{vector} of \code{raw} data, it needs to be structured as it would be
when stored in a binary file (see \code{\link[=read.AmigaBasicBMAP]{read.AmigaBasicBMAP()}}). \code{x} can also be a named \code{list},
where the name of each element corresponds with a routine in the library. Each element should than consist
of a \code{list} with 2 elements: The first should be named \verb{libraryVectorOffset' and should hold the }numeric\verb{offset of the routine in the library (see details). The second element should be named}registers' and should
contain a \code{vector} of \code{raw} values refering to CPU registers used by the routine (see details).}
}
\value{
Returns a \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} based on \code{x}
}
\description{
Coerce \code{raw} or named \code{list} to an \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} class object
}
\details{
An \link[=AmigaBasicBMAP]{Amiga Basic BMAP} file maps the offset of routines in Amiga libraries. This
function converts the raw format in which it would be stored as a file into a comprehensive S3 class object. It
can also convert a named list into an S3 class object. See \verb{Arguments' and }Examples' sections on how to format
this list.
}
\examples{
## For the dos.library, the start of the bmap list would look like:
dos.list <- list(
  xOpen = list(
    libraryVectorOffset = -30,
    registers = as.raw(2:3)
  ),
  xClose = list(
    libraryVectorOffset = -36,
    registers = as.raw(2)
  ),
  xRead = list(
    libraryVectorOffset = -42,
    registers = as.raw(2:4)
  )
)

## Note that the list above is incomplete, the dos.library holds more routines than shown here.
## This merely serves as an example.
## This list can be converted to an S3 class as follows:
dos.bmap <- as.AmigaBasicBMAP(dos.list)
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic}},
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{write.AmigaBasic}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
