% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{KPI_summary_table.as_data}
\alias{KPI_summary_table.as_data}
\title{KPI summary table}
\usage{
\method{KPI_summary_table}{as_data}(
  data_object,
  predictions = NULL,
  test = TRUE,
  normalized = FALSE,
  ...
)
}
\arguments{
\item{data_object}{an object of class \code{as_data}.}

\item{predictions}{a data frame with the predicted KPI for each algorithm (columns) and for each instance (rows). If NULL, the table won't include a ML column.}

\item{test}{flag that indicates whether the function should use test data or training data.}

\item{normalized}{whether to use the original values of the KPI or the normalized ones used for the learning.}

\item{...}{other parameters.}
}
\value{
A table with the statistics of the pace.
}
\description{
Function that generates a summary table of the KPI values. Optimal is the value of the KPI when choosing the best option for each instance. It's the best that we could do with respect to that KPI. Best is the value of the KPI for the best option overall according to the KPI. ML is the value of the KPI choosing for each instance the option selected by the learning.
}
\examples{
data(branchingsmall)
data_object <- partition_and_normalize(branchingsmall$x, branchingsmall$y, test_size = 0.3,
family_column = 1, split_by_family = TRUE)
training <- AStrain(data_object, method = "glm")
predictions <- ASpredict(training, newdata = data_object$x.test)
KPI_summary_table(data_object, predictions = predictions)
}
