#' Mango terrain requirement for land evaluation
    #' 
    #' A dataset containing the terrain characteristics of the crop requirements for farming Mango.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item Slope1 - Slope (\%) (1) Basin furrow irrigation
#' \item Slope2 - Slope (\%) (2) Mechanized, high management level
#' \item Slope3 - Slope (\%) (3) Manual, low management level
#' \item Flood - Flooding
#' \item Drainage - Drainage
#' \item SlopeD - 6 classes of slope (Degree)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 6 rows and 8 columns
#' @name MANGOTerrain
NULL