% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{hierarchicalClassify}
\alias{hierarchicalClassify}
\title{Hierarchical Deconvolution}
\usage{
hierarchicalClassify(
  sigMatrix,
  geneExpr,
  toPred,
  hierarchData = NULL,
  pdfDir = tempdir(),
  oneCore = FALSE,
  nPasses = 100,
  remZinf = TRUE,
  method = "DCQ",
  useRF = TRUE,
  incNonCluster = TRUE
)
}
\arguments{
\item{sigMatrix}{The deconvolution matrix, e.g. LM22 or MGSM27}

\item{geneExpr}{The source gene expression matrix used to calculate sigMatrix}

\item{toPred}{The gene expression to ultimately deconvolve}

\item{hierarchData}{The results of hierarchicalSplit OR hierarchicalSplit.sc (DEFAULT: NULL, ie hierarchicalSplit)}

\item{pdfDir}{A fold to write the pdf file to (DEFAULT: tempdir())}

\item{oneCore}{Set to TRUE to disable parallelization (DEFAULT: FALSE)}

\item{nPasses}{The maximum number of iterations for spillToConvergence (DEFAULT: 100)}

\item{remZinf}{Set to TRUE to remove any ratio with zero or infinity when generating gList (DEFAULT: FALSE)}

\item{method}{One of 'DCQ', 'SVMDECON', 'DeconRNASeq', 'proportionsInAdmixture', 'nnls' (DEFAULT: DCQ)}

\item{useRF}{Set to TRUE to use ranger random forests to build the seed matrix (DEFAULT: TRUE)}

\item{incNonCluster}{Set to TRUE to include a 'nonCluster' in each of the sub matrices (DEFAULT: TRUE)}
}
\value{
a matrix of cell counts
}
\description{
Deconvolve cell types based on clusters detected by an n-pass spillover matrix
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

cellCounts <- hierarchicalClassify(sigMatrix=smallLM22, geneExpr=fullLM22, toPred=fullLM22, 
    oneCore=TRUE, nPasses=10, method='DCQ')
}
