/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.r;

import com.google.protobuf.InvalidProtocolBufferException;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.r.util.Dictionaries;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsDictionaries;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsSpec;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsFactory;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsKernel;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsOutput;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsResults;
import jdplus.tramoseats.base.protobuf.Spec;
import jdplus.tramoseats.base.protobuf.SpecProto;
import jdplus.tramoseats.base.protobuf.TramoSeatsProtosUtility;
import jdplus.tramoseats.base.protobuf.TramoSeatsResultsProto;
import lombok.Generated;

public final class TramoSeats {
    public static byte[] toBuffer(TramoSeatsResults rslts) {
        return TramoSeatsResultsProto.convert((TramoSeatsResults)rslts).toByteArray();
    }

    public static TramoSeatsResults process(TsData series, String defSpec) {
        TramoSeatsSpec spec = TramoSeatsSpec.fromString((String)defSpec);
        TramoSeatsKernel kernel = TramoSeatsKernel.of((TramoSeatsSpec)spec, null);
        return kernel.process(series.cleanExtremities(), null);
    }

    public static TramoSeatsResults process(TsData series, TramoSeatsSpec spec, ModellingContext context) {
        TramoSeatsKernel kernel = TramoSeatsKernel.of((TramoSeatsSpec)spec, (ModellingContext)context);
        return kernel.process(series.cleanExtremities(), null);
    }

    public static TramoSeatsSpec refreshSpec(TramoSeatsSpec currentSpec, TramoSeatsSpec domainSpec, TsDomain domain, String policy) {
        return TramoSeatsFactory.getInstance().refreshSpec(currentSpec, domainSpec, EstimationPolicyType.valueOf((String)policy), domain);
    }

    public static byte[] toBuffer(TramoSeatsSpec spec) {
        return SpecProto.convert((TramoSeatsSpec)spec).toByteArray();
    }

    public static TramoSeatsSpec specOf(byte[] buffer) {
        try {
            Spec spec = Spec.parseFrom((byte[])buffer);
            return SpecProto.convert((Spec)spec);
        }
        catch (InvalidProtocolBufferException ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public static TramoSeatsOutput fullProcess(TsData series, TramoSeatsSpec spec, ModellingContext context) {
        TramoSeatsKernel tramoseats = TramoSeatsKernel.of((TramoSeatsSpec)spec, (ModellingContext)context);
        TramoSeatsResults estimation = tramoseats.process(series.cleanExtremities(), null);
        return TramoSeatsOutput.builder().estimationSpec(spec).result(estimation).resultSpec(estimation == null ? null : TramoSeatsFactory.getInstance().generateSpec(spec, estimation.getPreprocessing().getDescription())).build();
    }

    public static TramoSeatsOutput fullProcess(TsData series, String defSpec) {
        TramoSeatsSpec spec = TramoSeatsSpec.fromString((String)defSpec);
        return TramoSeats.fullProcess(series, spec, null);
    }

    public static byte[] toBuffer(TramoSeatsOutput output) {
        return TramoSeatsProtosUtility.convert((TramoSeatsOutput)output).toByteArray();
    }

    public static String[] dictionary() {
        return Dictionaries.entries((Dictionary)TramoSeatsDictionaries.TRAMOSEATSDICTIONARY);
    }

    public static String[] fullDictionary() {
        return Dictionaries.all((Dictionary)TramoSeatsDictionaries.TRAMOSEATSDICTIONARY);
    }

    @Generated
    private TramoSeats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

