## ----example1a, eval = FALSE--------------------------------------------------
# library(flexurba)
# 
# # make sure the time out is large enough to download all the data
# options(timeout = 500)
# 
# # download the GHSL data on a global scale and save it in
# # the directory "data/global"
# download_GHSLdata(output_directory = "data/global")
# 
# # crop the global grid to a custom extent (here: Belgium) and save it
# # in the directory "data/belgium"
# # the coordinates of the extent should be provided in the Mollweide projection
# crop_GHSLdata(
#   extent = terra::ext(192000, 485000, 5821000, 6030000),
#   global_directory = "data/global",
#   output_directory = "data/belgium"
# )

## ----example1b, eval = FALSE--------------------------------------------------
# # preprocess the data
# data_belgium <- DoU_preprocess_grid("data/belgium")
# 
# # run the algorithm with the standard parameter settings
# classification1 <- DoU_classify_grid(data = data_belgium)
# 
# # plot the resulting grid
# DoU_plot_grid(classification1)

## ----example1c, eval = FALSE--------------------------------------------------
# # run the algorithm with custom parameter settings
# classification2 <- DoU_classify_grid(
#   data = data_belgium,
#   parameters = list(
#     UC_density_threshold = 1250,
#     UC_size_threshold = 60000,
#     UC_gap_fill = FALSE,
#     UC_smooth_edge = FALSE
#   )
# )
# 
# # plot the resulting grid
# DoU_plot_grid(classification2)

## ----example2b, eval = FALSE--------------------------------------------------
# # preprocess the data
# data1 <- DoU_preprocess_units(
#   units = flexurba::units_belgium,
#   classification = classification1,
#   pop = "data/belgium/POP.tif"
# )
# 
# # run the algorithm for the units classification
# units_classification <- DoU_classify_units(data1)
# 
# # visualise the results
# plot_units(flexurba::units_belgium, classification = units_classification)

