/*
 * Decompiled with CFR 0.152.
 */
package ibd;

import blbutil.IntPair;
import blbutil.Utilities;
import dag.Dag;
import haplotype.HapPairs;
import haplotype.SampleHapPairs;
import ibd.HapSegment;
import ibd.IbdBaum;
import ibd.IbdSegment;
import ibd.IbsHapSegments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import main.GeneticMap;
import vcf.GL;

public final class HaploidIbd {
    private final GeneticMap genMap;
    private final int ibdTrim;
    private final float minIbdLod;
    private final float minFreqLod;
    private final float minCm;

    public HaploidIbd(GeneticMap geneticMap, int n, float f, float f2) {
        if (geneticMap == null) {
            throw new IllegalArgumentException(GeneticMap.class.toString());
        }
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if ((double)f <= 0.0 || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        if ((double)f2 <= 0.0 || !Float.isFinite(f2)) {
            throw new IllegalArgumentException(String.valueOf(f2));
        }
        this.genMap = geneticMap;
        this.ibdTrim = n;
        this.minIbdLod = f;
        this.minFreqLod = f;
        this.minCm = f2;
    }

    public Map<IntPair, List<IbdSegment>> run(GL gL, Dag dag, SampleHapPairs sampleHapPairs, int n) {
        int n2;
        this.checkParameters(gL, dag, sampleHapPairs);
        double[] dArray = this.genMap.genPos(dag.markers());
        IbsHapSegments ibsHapSegments = new IbsHapSegments(sampleHapPairs, dArray, this.minCm);
        ConcurrentHashMap<IntPair, List<IbdSegment>> concurrentHashMap = new ConcurrentHashMap<IntPair, List<IbdSegment>>();
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(5 * n);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (n2 = 0; n2 < n; ++n2) {
            IbdBaum ibdBaum = new IbdBaum(dag, gL);
            executorService.submit(new ProduceIbd(sampleHapPairs, ibdBaum, ibsHapSegments, arrayBlockingQueue, concurrentHashMap, this.ibdTrim, this.minIbdLod));
        }
        try {
            int n3 = sampleHapPairs.nHaps();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayBlockingQueue.put(n2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                arrayBlockingQueue.put(-37);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        return concurrentHashMap;
    }

    private void checkParameters(GL gL, Dag dag, SampleHapPairs sampleHapPairs) {
        if (!gL.samples().equals(sampleHapPairs.samples())) {
            throw new IllegalArgumentException("inconstent samples");
        }
        if (!gL.markers().equals(dag.markers()) || !gL.markers().equals(sampleHapPairs.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
    }

    private static double freqLod(int n, int n2, int n3, int n4, Dag dag, HapPairs hapPairs) {
        int n5 = n2 + n4;
        int n6 = n3 - n4;
        if (n5 >= n6) {
            return 0.0;
        }
        return IbdBaum.freqLod(n, n5, n6, hapPairs, dag);
    }

    private static double ibdLod(IbdBaum ibdBaum, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 + n5;
        int n7 = n4 - n5;
        if (n6 >= n7) {
            return 0.0;
        }
        int n8 = n / 2;
        int n9 = n2 / 2;
        return ibdBaum.ibdLod(n8, n9, n6, n7);
    }

    private class ProduceIbd
    implements Runnable {
        public static final int POISON = -37;
        private final SampleHapPairs haps;
        private final IbdBaum baum;
        private final IbsHapSegments ibsHapSegments;
        private final BlockingQueue<Integer> qIn;
        private final ConcurrentMap<IntPair, List<IbdSegment>> ibdMap;
        private final int ibdTrim;
        private final float minIbdLod;

        public ProduceIbd(SampleHapPairs sampleHapPairs, IbdBaum ibdBaum, IbsHapSegments ibsHapSegments, BlockingQueue<Integer> blockingQueue, ConcurrentMap<IntPair, List<IbdSegment>> concurrentMap, int n, float f) {
            if (n < 0) {
                throw new IllegalArgumentException("trim < 0: " + n);
            }
            if ((double)f <= 0.0 || Float.isNaN(f)) {
                throw new IllegalArgumentException("ibdlod: " + f);
            }
            this.haps = sampleHapPairs;
            this.baum = ibdBaum;
            this.ibsHapSegments = ibsHapSegments;
            this.qIn = blockingQueue;
            this.ibdMap = concurrentMap;
            this.ibdTrim = n;
            this.minIbdLod = f;
        }

        @Override
        public void run() {
            try {
                int n = this.qIn.take();
                while (n != -37) {
                    List<HapSegment> list = this.ibsHapSegments.find(n);
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        float f;
                        int n3;
                        int n4;
                        double d;
                        HapSegment hapSegment = list.get(i);
                        if (n >= hapSegment.hap() || !((d = HaploidIbd.freqLod(n, n4 = hapSegment.start(), (n3 = hapSegment.end()) + 1, this.ibdTrim, this.baum.dag(), this.haps)) >= (double)HaploidIbd.this.minFreqLod)) continue;
                        if (n / 2 == hapSegment.hap() / 2) {
                            int n5 = n / 2;
                            f = (float)this.baum.hbdLod(n5, n4, n3 + 1);
                        } else {
                            f = (float)HaploidIbd.ibdLod(this.baum, n, hapSegment.hap(), n4, n3 + 1, this.ibdTrim);
                        }
                        if (!(f >= this.minIbdLod)) continue;
                        IntPair intPair = new IntPair(n, hapSegment.hap());
                        List list2 = (List)this.ibdMap.get(intPair);
                        if (list2 == null) {
                            list2 = Collections.synchronizedList(new ArrayList(2));
                            this.ibdMap.putIfAbsent(intPair, list2);
                            list2 = (List)this.ibdMap.get(intPair);
                        }
                        IbdSegment ibdSegment = new IbdSegment(intPair, this.baum.gl().marker(n4), this.baum.gl().marker(n3), f, n4, n3);
                        list2.add(ibdSegment);
                    }
                    n = this.qIn.take();
                }
            }
            catch (Throwable throwable) {
                Utilities.exit("ProduceSingleSamples: ERROR", throwable);
            }
        }
    }
}

