/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.stats;

import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.Exponential;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.dstats.Gamma;
import jdplus.toolkit.base.core.dstats.InverseGamma;
import jdplus.toolkit.base.core.dstats.InverseGaussian;
import jdplus.toolkit.base.core.dstats.LogNormal;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.random.XorshiftRNG;
import lombok.Generated;

public final class Distributions {
    public static double[] randomsT(double df, int n) {
        T dist = new T(df);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfT(double df, double[] x) {
        T dist = new T(df);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityT(double df, double[] x) {
        T dist = new T(df);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsChi2(double df, int n) {
        Chi2 dist = new Chi2(df);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfChi2(double df, double[] x) {
        Chi2 dist = new Chi2(df);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityChi2(double df, double[] x) {
        Chi2 dist = new Chi2(df);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsF(double dfnum, double dfdenom, int n) {
        F dist = new F(dfnum, dfdenom);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfF(double dfnum, double dfdenom, double[] x) {
        F dist = new F(dfnum, dfdenom);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityF(double dfnum, double dfdenom, double[] x) {
        F dist = new F(dfnum, dfdenom);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsNormal(double mean, double stdev, int n) {
        Normal dist = new Normal(mean, stdev);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfNormal(double mean, double stdev, double[] x) {
        Normal dist = new Normal(mean, stdev);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityNormal(double mean, double stdev, double[] x) {
        Normal dist = new Normal(mean, stdev);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsLogNormal(double mean, double stdev, int n) {
        LogNormal dist = new LogNormal(mean, stdev);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfLogNormal(double mean, double stdev, double[] x) {
        LogNormal dist = new LogNormal(mean, stdev);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityLogNormal(double mean, double stdev, double[] x) {
        LogNormal dist = new LogNormal(mean, stdev);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsGamma(double shape, double scale, int n) {
        Gamma dist = new Gamma(shape, scale);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfGamma(double shape, double scale, double[] x) {
        Gamma dist = new Gamma(shape, scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityGamma(double shape, double scale, double[] x) {
        Gamma dist = new Gamma(shape, scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsInverseGamma(double shape, double scale, int n) {
        InverseGamma dist = new InverseGamma(shape, scale);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfInverseGamma(double shape, double scale, double[] x) {
        InverseGamma dist = new InverseGamma(shape, scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityInverseGamma(double shape, double scale, double[] x) {
        InverseGamma dist = new InverseGamma(shape, scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsInverseGaussian(double shape, double scale, int n) {
        InverseGaussian dist = new InverseGaussian(shape, scale);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfInverseGaussian(double shape, double scale, double[] x) {
        InverseGaussian dist = new InverseGaussian(shape, scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityInverseGaussian(double shape, double scale, double[] x) {
        InverseGaussian dist = new InverseGaussian(shape, scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    public static double[] randomsExponential(double scale, int n) {
        Exponential dist = new Exponential(scale);
        XorshiftRNG rnd = XorshiftRNG.fromSystemNanoTime();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = dist.random((RandomNumberGenerator)rnd);
        }
        return r;
    }

    public static double[] cdfExponential(double scale, double[] x) {
        Exponential dist = new Exponential(scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getProbability(x[i], ProbabilityType.Lower);
        }
        return r;
    }

    public static double[] densityExponential(double scale, double[] x) {
        Exponential dist = new Exponential(scale);
        double[] r = new double[x.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = dist.getDensity(x[i]);
        }
        return r;
    }

    @Generated
    private Distributions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

