/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.text.UncloseableReader;
import internal.io.text.UncloseableWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Optional;
import lombok.NonNull;
import nbbrd.io.Resource;

public final class TextResource {
    private TextResource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Deprecated
    @NonNull
    public static Optional<BufferedReader> getResourceAsBufferedReader(@NonNull Class<?> anchor, @NonNull String name, @NonNull Charset charset) {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return Resource.getResourceAsStream(anchor, name).map(stream -> TextResource.newBufferedReader(stream, charset));
    }

    @NonNull
    public static BufferedReader newBufferedReader(@NonNull Class<?> anchor, @NonNull String name, @NonNull Charset charset) throws IOException {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return TextResource.newBufferedReader(Resource.newInputStream(anchor, name), charset);
    }

    @NonNull
    public static BufferedReader newBufferedReader(@NonNull Class<?> anchor, @NonNull String name, @NonNull CharsetDecoder decoder) throws IOException {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        return TextResource.newBufferedReader(Resource.newInputStream(anchor, name), TextResource.configureDecoderForInputStreamReader(decoder));
    }

    @NonNull
    public static BufferedReader newBufferedReader(@NonNull InputStream stream, @NonNull Charset charset) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return new BufferedReader(new InputStreamReader(stream, charset));
    }

    @NonNull
    public static BufferedReader newBufferedReader(@NonNull InputStream stream, @NonNull CharsetDecoder decoder) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        return new BufferedReader(new InputStreamReader(stream, TextResource.configureDecoderForInputStreamReader(decoder)));
    }

    @NonNull
    private static CharsetDecoder configureDecoderForInputStreamReader(@NonNull CharsetDecoder decoder) {
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        return decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @NonNull
    public static BufferedWriter newBufferedWriter(@NonNull OutputStream stream, @NonNull CharsetEncoder encoder) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (encoder == null) {
            throw new NullPointerException("encoder is marked non-null but is null");
        }
        return new BufferedWriter(new OutputStreamWriter(stream, encoder));
    }

    @NonNull
    public static Reader uncloseableReader(@NonNull Reader delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        return new UncloseableReader(delegate);
    }

    @NonNull
    public static Writer uncloseableWriter(@NonNull Writer delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        return new UncloseableWriter(delegate);
    }
}

