/*
 * Decompiled with CFR 0.152.
 */
package jdplus.spreadsheet.base.api.sa;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArrayBook;
import ec.util.spreadsheet.helpers.ArraySheet;
import internal.spreadsheet.base.api.SpreadsheetManager;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdplus.sa.base.api.SaDocument;
import jdplus.spreadsheet.base.api.sa.SpreadsheetOutputConfiguration;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.Output;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataTable;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.util.MultiLineNameUtil;
import jdplus.toolkit.base.api.util.NamedObject;
import jdplus.toolkit.base.api.util.Paths;

public final class SpreadsheetOutput
implements Output<SaDocument> {
    private final SpreadsheetOutputConfiguration config;
    private final SpreadsheetManager spreadsheetManager;
    private final List<Summary> summaries;
    private File folder;

    public SpreadsheetOutput(SpreadsheetOutputConfiguration config) {
        this(config, SpreadsheetManager.ofServiceLoader());
    }

    SpreadsheetOutput(SpreadsheetOutputConfiguration config, SpreadsheetManager spreadsheetManager) {
        this.config = config.clone();
        this.spreadsheetManager = spreadsheetManager;
        this.summaries = new ArrayList<Summary>();
    }

    public void process(SaDocument document) {
        Summary summary = Summary.of(document.getName(), document.getResults(), this.config.getSeries());
        this.summaries.add(summary);
    }

    public void start(Object context) {
        this.summaries.clear();
        this.folder = Paths.folderFromContext((File)this.config.getFolder(), (Object)context);
    }

    public void end(Object context) throws Exception {
        File ssfile = this.getOutputFile();
        Book.Factory factory = this.spreadsheetManager.getWriter(ssfile).orElseThrow(() -> new IOException("Cannot find spreadsheet writer for file '" + String.valueOf(ssfile) + "'"));
        ArrayBook.Builder workbook = ArrayBook.builder();
        switch (this.config.getLayout()) {
            case ByComponent: {
                LinkedHashMap allData = new LinkedHashMap();
                for (Summary summary : this.summaries) {
                    String name = this.getDisplayName(summary);
                    summary.series().forEach((k, v) -> allData.computeIfAbsent(k, ignore -> new ArrayList()).add(new NamedObject(name, v)));
                }
                for (Map.Entry entry : allData.entrySet()) {
                    String sheetName = (String)entry.getKey();
                    ArrayList<String> firstHeader = new ArrayList<String>();
                    ArrayList<String> secondHeader = new ArrayList<String>();
                    ArrayList<TsData> table = new ArrayList<TsData>();
                    firstHeader.add((String)entry.getKey());
                    ((List)entry.getValue()).forEach(data -> {
                        secondHeader.add(data.getName());
                        table.add(SpreadsheetOutput.nullToEmpty(data.getName(), (TsData)data.getObject()));
                    });
                    workbook.sheet((Sheet)SpreadsheetOutput.toSheet(sheetName, firstHeader, secondHeader, table, this.config.isVerticalOrientation()));
                }
                break;
            }
            case BySeries: {
                for (int sheetIndex = 0; sheetIndex < this.summaries.size(); ++sheetIndex) {
                    Summary summary = this.summaries.get(sheetIndex);
                    String string = "Series" + sheetIndex;
                    ArrayList<String> firstHeader = new ArrayList<String>();
                    ArrayList<String> secondHeader = new ArrayList<String>();
                    ArrayList<TsData> table = new ArrayList<TsData>();
                    firstHeader.add(this.getDisplayName(summary));
                    summary.series().forEach((k, v) -> {
                        secondHeader.add((String)k);
                        table.add(SpreadsheetOutput.nullToEmpty(k, v));
                    });
                    workbook.sheet((Sheet)SpreadsheetOutput.toSheet(string, firstHeader, secondHeader, table, this.config.isVerticalOrientation()));
                }
                break;
            }
            case OneSheet: {
                String sheetName = "Series";
                ArrayList<String> firstHeader = new ArrayList<String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<TsData> table = new ArrayList<TsData>();
                for (Summary summary : this.summaries) {
                    firstHeader.add(this.getDisplayName(summary));
                    for (int columnIndex = 1; columnIndex < summary.series().size(); ++columnIndex) {
                        firstHeader.add(null);
                    }
                    summary.series().forEach((k, v) -> {
                        secondHeader.add((String)k);
                        table.add(SpreadsheetOutput.nullToEmpty(k, v));
                    });
                }
                workbook.sheet((Sheet)SpreadsheetOutput.toSheet(sheetName, firstHeader, arrayList, table, this.config.isVerticalOrientation()));
                break;
            }
        }
        factory.store(ssfile, (Book)workbook.build());
    }

    public String getName() {
        return "Spreadsheet";
    }

    public boolean isAvailable() {
        return true;
    }

    private File getOutputFile() {
        return this.folder.toPath().resolve(this.config.getFileName()).toFile().getAbsoluteFile();
    }

    private String getDisplayName(Summary summary) {
        return this.config.isFullName() ? MultiLineNameUtil.join((String)summary.name(), (String)" * ") : MultiLineNameUtil.last((String)summary.name());
    }

    private static TsData nullToEmpty(String k, TsData v) {
        return v != null ? v : TsData.empty((String)("MISSING " + k));
    }

    private static ArraySheet toSheet(String sheetName, List<String> headers0, List<String> headers1, List<TsData> collection, boolean verticalOrientation) {
        TsDataTable table = TsDataTable.of(collection);
        ArraySheet.Builder result = ArraySheet.builder().name(sheetName);
        if (verticalOrientation) {
            result.row(0, 1, headers0);
            result.row(1, 1, headers1);
            TsDataTable.Cursor cursor = table.cursor(TsDataTable.DistributionType.FIRST);
            for (int p = 0; p < cursor.getPeriodCount(); ++p) {
                ArrayList<Comparable<Date>> data = new ArrayList<Comparable<Date>>();
                data.add(SpreadsheetOutput.toDate(table.getDomain().get(p)));
                for (int s = 0; s < cursor.getSeriesCount(); ++s) {
                    TsDataTable.ValueStatus status = cursor.moveTo(p, s).getStatus();
                    data.add(status == TsDataTable.ValueStatus.PRESENT ? Double.valueOf(cursor.getValue()) : null);
                }
                result.row(2 + p, 0, data);
            }
        } else {
            result.column(1, 0, headers0);
            result.column(1, 1, headers1);
            TsDataTable.Cursor cursor = table.cursor(TsDataTable.DistributionType.FIRST);
            for (int p = 0; p < cursor.getPeriodCount(); ++p) {
                ArrayList<Comparable<Date>> data = new ArrayList<Comparable<Date>>();
                data.add(SpreadsheetOutput.toDate(table.getDomain().get(p)));
                for (int s = 0; s < cursor.getSeriesCount(); ++s) {
                    TsDataTable.ValueStatus status = cursor.moveTo(p, s).getStatus();
                    data.add(status == TsDataTable.ValueStatus.PRESENT ? Double.valueOf(cursor.getValue()) : null);
                }
                result.column(0, 2 + p, data);
            }
        }
        return result.build();
    }

    private static Date toDate(TsPeriod period) {
        return Date.from(period.start().atZone(ZoneId.systemDefault()).toInstant());
    }

    private record Summary(String name, LinkedHashMap<String, TsData> series) {
        public static Summary of(String name, Explorable results, List<String> items) {
            LinkedHashMap<String, TsData> series = new LinkedHashMap<String, TsData>();
            for (String item : items) {
                series.put(item, results != null ? (TsData)results.getData(item, TsData.class) : null);
            }
            return new Summary(name, series);
        }
    }
}

